/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.item;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.Subscribe;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.plexus.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.proxy.NoSuchRepositoryException;
import org.sonatype.nexus.proxy.events.NexusStoppedEvent;
import org.sonatype.nexus.proxy.item.DefaultRepositoryItemUid;
import org.sonatype.nexus.proxy.item.DefaultRepositoryItemUidLock;
import org.sonatype.nexus.proxy.item.LockResource;
import org.sonatype.nexus.proxy.item.RepositoryItemUid;
import org.sonatype.nexus.proxy.item.RepositoryItemUidFactory;
import org.sonatype.nexus.proxy.item.RepositoryItemUidLock;
import org.sonatype.nexus.proxy.item.SimpleLockResource;
import org.sonatype.nexus.proxy.item.SisuLockResource;
import org.sonatype.nexus.proxy.registry.RepositoryRegistry;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.sisu.goodies.eventbus.EventBus;
import org.sonatype.sisu.locks.ResourceLockFactory;

@Singleton
@Named
public class DefaultRepositoryItemUidFactory
implements RepositoryItemUidFactory {
    private static final Logger log = LoggerFactory.getLogger(DefaultRepositoryItemUidFactory.class);
    private final EventBus eventBus;
    private final RepositoryRegistry repositoryRegistry;
    private final ResourceLockFactory sisuLockFactory;
    private final WeakHashMap<DefaultRepositoryItemUidLock, WeakReference<DefaultRepositoryItemUidLock>> locks = new WeakHashMap();

    @Inject
    public DefaultRepositoryItemUidFactory(EventBus eventBus, RepositoryRegistry repositoryRegistry, @Nullable @Named(value="${sisu-resource-locks:-local}") ResourceLockFactory sisuLockFactory) {
        this.eventBus = (EventBus)Preconditions.checkNotNull((Object)eventBus);
        this.repositoryRegistry = (RepositoryRegistry)Preconditions.checkNotNull((Object)repositoryRegistry);
        this.sisuLockFactory = sisuLockFactory;
        log.debug("Lock factory: {}", (Object)sisuLockFactory);
        eventBus.register((Object)this);
    }

    @Override
    public DefaultRepositoryItemUid createUid(Repository repository, String path) {
        if (!StringUtils.isEmpty((String)path)) {
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            Preconditions.checkArgument((!path.contains("/..") ? 1 : 0) != 0, (String)"Repository UID path may NOT contain relative tokens: %s", (Object[])new Object[]{path});
        } else {
            path = "/";
        }
        return new DefaultRepositoryItemUid(this, repository, path);
    }

    @Override
    public DefaultRepositoryItemUid createUid(String uidStr) throws IllegalArgumentException, NoSuchRepositoryException {
        if (uidStr.indexOf(":") > -1) {
            String[] parts = uidStr.split(":");
            if (parts.length == 2) {
                Repository repository = this.repositoryRegistry.getRepository(parts[0]);
                return this.createUid(repository, parts[1]);
            }
            throw new IllegalArgumentException(uidStr + " is malformed RepositoryItemUid! The proper format is '<repoId>:/path/to/something'.");
        }
        throw new IllegalArgumentException(uidStr + " is malformed RepositoryItemUid! The proper format is '<repoId>:/path/to/something'.");
    }

    @Override
    public DefaultRepositoryItemUidLock createUidLock(RepositoryItemUid uid) {
        String key = new String(uid.getKey());
        return this.doCreateUidLockForKey(key);
    }

    protected synchronized DefaultRepositoryItemUidLock doCreateUidLockForKey(String key) {
        RepositoryItemUidLock oldLock;
        LockResource lockResource = this.sisuLockFactory != null ? new SisuLockResource(this.sisuLockFactory.getResourceLock(key)) : new SimpleLockResource();
        DefaultRepositoryItemUidLock newLock = new DefaultRepositoryItemUidLock(key, lockResource);
        WeakReference<DefaultRepositoryItemUidLock> oldLockRef = this.locks.get(newLock);
        if (oldLockRef != null && (oldLock = (RepositoryItemUidLock)oldLockRef.get()) != null) {
            return (DefaultRepositoryItemUidLock)oldLockRef.get();
        }
        this.locks.put(newLock, new WeakReference<DefaultRepositoryItemUidLock>(newLock));
        return newLock;
    }

    protected int locksInMap() {
        return this.locks.size();
    }

    @Subscribe
    public void on(NexusStoppedEvent e) {
        this.eventBus.unregister((Object)this);
        if (this.sisuLockFactory != null) {
            this.sisuLockFactory.shutdown();
        }
    }
}

