/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.item;

import org.sonatype.nexus.proxy.item.RepositoryItemUid;
import org.sonatype.nexus.proxy.item.RepositoryItemUidFactory;
import org.sonatype.nexus.proxy.item.RepositoryItemUidLock;
import org.sonatype.nexus.proxy.item.uid.Attribute;
import org.sonatype.nexus.proxy.repository.Repository;

public class DefaultRepositoryItemUid
implements RepositoryItemUid {
    private final RepositoryItemUidFactory factory;
    private final Repository repository;
    private final String path;
    private final String stringRepresentation;
    private RepositoryItemUidLock lock;

    protected DefaultRepositoryItemUid(RepositoryItemUidFactory factory, Repository repository, String path) {
        this.factory = factory;
        this.repository = repository;
        this.path = path;
        this.stringRepresentation = this.getRepository().getId() + ":" + this.getPath();
        this.lock = null;
    }

    public RepositoryItemUidFactory getRepositoryItemUidFactory() {
        return this.factory;
    }

    @Override
    public String getKey() {
        return this.stringRepresentation;
    }

    @Override
    public Repository getRepository() {
        return this.repository;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public synchronized RepositoryItemUidLock getLock() {
        if (this.lock == null) {
            this.lock = this.factory.createUidLock(this);
        }
        return this.lock;
    }

    public <A extends Attribute<?>> A getAttribute(Class<A> attrClass) {
        return this.getRepository().getRepositoryItemUidAttributeManager().getAttribute(attrClass, this);
    }

    @Override
    public <A extends Attribute<V>, V> V getAttributeValue(Class<A> attrClass) {
        A attr = this.getAttribute(attrClass);
        if (attr != null) {
            return attr.getValueFor(this);
        }
        return null;
    }

    @Override
    public <A extends Attribute<Boolean>> boolean getBooleanAttributeValue(Class<A> attr) {
        Boolean bool = (Boolean)this.getAttributeValue(attr);
        return bool != null && bool != false;
    }

    public String toString() {
        return this.stringRepresentation;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.stringRepresentation == null ? 0 : this.stringRepresentation.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultRepositoryItemUid other = (DefaultRepositoryItemUid)obj;
        return !(this.stringRepresentation == null ? other.stringRepresentation != null : !this.stringRepresentation.equals(other.stringRepresentation));
    }
}

