/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.item;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.proxy.NoSuchRepositoryException;
import org.sonatype.nexus.proxy.item.ContentLocator;
import org.sonatype.nexus.proxy.item.LinkPersister;
import org.sonatype.nexus.proxy.item.RepositoryItemUid;
import org.sonatype.nexus.proxy.item.RepositoryItemUidFactory;
import org.sonatype.nexus.proxy.item.StorageLinkItem;
import org.sonatype.nexus.util.io.StreamSupport;

@Named
@Singleton
public class DefaultLinkPersister
implements LinkPersister {
    private static final Charset LINK_CHARSET = Charsets.UTF_8;
    private static final String LINK_PREFIX = "LINK to ";
    private static final byte[] LINK_PREFIX_BYTES = "LINK to ".getBytes(LINK_CHARSET);
    private final RepositoryItemUidFactory repositoryItemUidFactory;

    @Inject
    public DefaultLinkPersister(RepositoryItemUidFactory repositoryItemUidFactory) {
        this.repositoryItemUidFactory = (RepositoryItemUidFactory)Preconditions.checkNotNull((Object)repositoryItemUidFactory);
    }

    @Override
    public boolean isLinkContent(ContentLocator locator) throws IOException {
        byte[] buf = this.getLinkPrefixBytes(locator);
        if (buf != null) {
            return Arrays.equals(buf, LINK_PREFIX_BYTES);
        }
        return false;
    }

    @Override
    public RepositoryItemUid readLinkContent(ContentLocator locator) throws NoSuchRepositoryException, IOException {
        if (locator != null) {
            try (InputStream is = locator.getContent();){
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                StreamSupport.copy(is, baos, StreamSupport.BUFFER_SIZE);
                String linkBody = new String(baos.toByteArray(), LINK_CHARSET);
                String uidStr = linkBody.substring(LINK_PREFIX.length(), linkBody.length());
                RepositoryItemUid repositoryItemUid = this.repositoryItemUidFactory.createUid(uidStr);
                return repositoryItemUid;
            }
        }
        return null;
    }

    @Override
    public void writeLinkContent(StorageLinkItem link, OutputStream os) throws IOException {
        try (OutputStream out = os;){
            String linkBody = LINK_PREFIX + link.getTarget().toString();
            StreamSupport.copy(new ByteArrayInputStream(linkBody.getBytes(LINK_CHARSET)), out, StreamSupport.BUFFER_SIZE);
            out.flush();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected byte[] getLinkPrefixBytes(ContentLocator locator) throws IOException {
        if (locator == null) return null;
        try (DataInputStream dis = new DataInputStream(locator.getContent());){
            byte[] buf = new byte[LINK_PREFIX_BYTES.length];
            dis.readFully(buf);
            byte[] byArray = buf;
            return byArray;
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return null;
    }
}

