/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.item;

import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import org.sonatype.nexus.proxy.RequestContext;
import org.sonatype.nexus.proxy.item.AbstractWrappingContentLocator;
import org.sonatype.nexus.proxy.item.ContentLocator;
import org.sonatype.nexus.util.DigesterUtils;

public class ChecksummingContentLocator
extends AbstractWrappingContentLocator {
    private final MessageDigest messageDigest;
    private final String contextKey;
    private final RequestContext context;

    public ChecksummingContentLocator(ContentLocator content, MessageDigest messageDigest, String contextKey, RequestContext context) {
        super(content);
        this.messageDigest = messageDigest;
        this.contextKey = contextKey;
        this.context = context;
    }

    @Override
    public InputStream getContent() throws IOException {
        this.messageDigest.reset();
        return new DigestCalculatingInputStream(this.getTarget().getContent(), this.messageDigest, this.contextKey, this.context);
    }

    private static class DigestCalculatingInputStream
    extends DigestInputStream {
        private final String contextKey;
        private final RequestContext context;

        public DigestCalculatingInputStream(InputStream source, MessageDigest messageDigest, String contextKey, RequestContext context) throws IllegalArgumentException {
            super(source, messageDigest);
            this.contextKey = contextKey;
            this.context = context;
        }

        @Override
        public int read() throws IOException {
            int result = super.read();
            if (result == -1) {
                this.setHash();
            }
            return result;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int result = super.read(b, off, len);
            if (result == -1) {
                this.setHash();
            }
            return result;
        }

        protected synchronized void setHash() throws IOException {
            if (!this.context.containsKey(this.contextKey, false)) {
                this.context.put(this.contextKey, (Object)DigesterUtils.getDigestAsString(this.getMessageDigest().digest()));
            }
        }
    }
}

