/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.item;

import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.sonatype.nexus.proxy.ItemNotFoundException;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.access.Action;
import org.sonatype.nexus.proxy.attributes.inspectors.DigestCalculatingInspector;
import org.sonatype.nexus.proxy.item.RepositoryItemUid;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.item.StringContentLocator;
import org.sonatype.nexus.proxy.maven.MUtils;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.storage.local.fs.DefaultFSLocalRepositoryStorage;
import org.sonatype.nexus.proxy.walker.AbstractFileWalkerProcessor;
import org.sonatype.nexus.proxy.walker.DefaultWalkerContext;
import org.sonatype.nexus.proxy.walker.Walker;
import org.sonatype.nexus.proxy.walker.WalkerContext;
import org.sonatype.nexus.proxy.walker.WalkerException;
import org.sonatype.nexus.util.DigesterUtils;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Named
public class ChecksumReconciler
extends ComponentSupport {
    private final Walker walker;
    private final DigestCalculatingInspector digestCalculatingInspector;
    private final MessageDigest sha1;
    private final MessageDigest md5;
    private File attributesBaseDir;
    private long modifiedSinceMillis;

    @Inject
    public ChecksumReconciler(Walker walker, DigestCalculatingInspector digestCalculatingInspector) throws NoSuchAlgorithmException {
        this.walker = walker;
        this.digestCalculatingInspector = digestCalculatingInspector;
        this.sha1 = MessageDigest.getInstance("SHA1");
        this.md5 = MessageDigest.getInstance("MD5");
    }

    public void reconcileChecksums(Repository repo, ResourceStoreRequest request, long sinceMillis) {
        block3: {
            DefaultWalkerContext context = new DefaultWalkerContext(repo, request);
            final String repositoryId = repo.getId();
            this.attributesBaseDir = this.getAttributesBaseDir(repo);
            this.modifiedSinceMillis = sinceMillis;
            if (this.attributesBaseDir == null) {
                return;
            }
            context.getProcessors().add(new AbstractFileWalkerProcessor(){

                @Override
                protected void processFileItem(WalkerContext ctx, StorageFileItem item) throws Exception {
                    if (repositoryId.equals(item.getRepositoryId())) {
                        ChecksumReconciler.this.reconcileItemChecksum(ctx.getRepository(), item);
                    }
                }
            });
            try {
                this.walker.walk(context);
            }
            catch (WalkerException e) {
                if (e.getWalkerContext().getStopCause() instanceof ItemNotFoundException) break block3;
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reconcileItemChecksum(Repository repo, StorageFileItem item) throws Exception {
        String itemPath;
        String localSHA1 = item.getRepositoryItemAttributes().get(DigestCalculatingInspector.DIGEST_SHA1_KEY);
        String remoteSHA1 = item.getRepositoryItemAttributes().get("remote.sha1");
        if ((localSHA1 != null || remoteSHA1 != null) && this.shouldAttemptReconciliation(itemPath = item.getPath())) {
            this.sha1.reset();
            this.md5.reset();
            try (DigestInputStream is = new DigestInputStream(new DigestInputStream(item.getContentLocator().getContent(), this.sha1), this.md5);){
                byte[] buf = new byte[8];
                ByteStreams.read((InputStream)is, (byte[])buf, (int)0, (int)8);
                this.sha1.update(buf);
                this.md5.update(buf);
                ByteStreams.copy((InputStream)is, (OutputStream)ByteStreams.nullOutputStream());
            }
            String affectedSHA1 = DigesterUtils.getDigestAsString(this.sha1.digest());
            if (localSHA1 != null && localSHA1.equals(affectedSHA1) || remoteSHA1 != null && remoteSHA1.equals(affectedSHA1)) {
                this.log.info("Reconciling attribute checksums for {}", (Object)item);
                RepositoryItemUid uid = item.getRepositoryItemUid();
                uid.getLock().lock(Action.update);
                try {
                    item.getRepositoryItemAttributes().remove("remote.sha1");
                    item.getRepositoryItemAttributes().remove("remote.md5");
                    this.digestCalculatingInspector.processStorageItem(item);
                    repo.getAttributesHandler().storeAttributes(item);
                }
                finally {
                    uid.getLock().unlock();
                }
            }
            this.reconcileChecksumFile(repo, itemPath + ".sha1", affectedSHA1, item.getRepositoryItemAttributes().get(DigestCalculatingInspector.DIGEST_SHA1_KEY));
            String affectedMD5 = DigesterUtils.getDigestAsString(this.md5.digest());
            this.reconcileChecksumFile(repo, itemPath + ".md5", affectedMD5, item.getRepositoryItemAttributes().get(DigestCalculatingInspector.DIGEST_MD5_KEY));
        }
    }

    private File getAttributesBaseDir(Repository repo) {
        try {
            if (repo.getLocalStorage() instanceof DefaultFSLocalRepositoryStorage) {
                File baseDir = ((DefaultFSLocalRepositoryStorage)repo.getLocalStorage()).getBaseDir(repo, null);
                return new File(new File(baseDir, ".nexus"), "attributes");
            }
        }
        catch (Exception e) {
            this.log.warn("Problem finding local storage for {}", (Object)repo, (Object)e);
        }
        return null;
    }

    private boolean shouldAttemptReconciliation(String itemPath) {
        if (itemPath == null || itemPath.endsWith(".sha1") || itemPath.endsWith(".md5")) {
            return false;
        }
        File attributesFile = new File(this.attributesBaseDir, StringUtils.strip((String)itemPath, (String)"/"));
        return attributesFile.lastModified() >= this.modifiedSinceMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconcileChecksumFile(Repository repo, String path, String oldValue, String newValue) {
        block6: {
            try {
                ResourceStoreRequest request = new ResourceStoreRequest(path, true, false);
                if (!repo.getLocalStorage().containsItem(repo, request)) break block6;
                StorageFileItem item = (StorageFileItem)((Object)repo.getLocalStorage().retrieveItem(repo, request));
                RepositoryItemUid uid = item.getRepositoryItemUid();
                uid.getLock().lock(Action.update);
                try {
                    if (oldValue.equals(MUtils.readDigestFromFileItem(item))) {
                        this.log.info("Reconciling checksum in {}", (Object)item);
                        item.setContentLocator(new StringContentLocator(newValue));
                        repo.getLocalStorage().storeItem(repo, item);
                    }
                }
                finally {
                    uid.getLock().unlock();
                }
            }
            catch (Exception e) {
                this.log.warn("Problem reconciling {} with new checksum", (Object)path, (Object)e);
            }
        }
    }
}

