/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.item;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.sonatype.nexus.proxy.item.AbstractContentLocator;

public class ByteArrayContentLocator
extends AbstractContentLocator {
    private final byte[] content;

    public ByteArrayContentLocator(byte[] content, String mimeType) {
        super(mimeType, true, content.length);
        this.content = Arrays.copyOf(content, content.length);
    }

    @Override
    public InputStream getContent() throws IOException {
        return new ByteArrayInputStream(this.content);
    }

    public byte[] getByteArray() {
        return this.content;
    }
}

