/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.item;

import com.google.common.base.Strings;
import java.io.File;
import java.util.Map;
import org.sonatype.nexus.proxy.RequestContext;
import org.sonatype.nexus.proxy.ResourceStore;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.attributes.Attributes;
import org.sonatype.nexus.proxy.attributes.internal.DefaultAttributes;
import org.sonatype.nexus.proxy.item.RepositoryItemUid;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.router.RepositoryRouter;
import org.sonatype.nexus.util.PathUtils;

public abstract class AbstractStorageItem
implements StorageItem {
    private transient ResourceStoreRequest request;
    private transient RepositoryItemUid repositoryItemUid;
    private transient ResourceStore store;
    private transient RequestContext context = new RequestContext();
    private transient Attributes itemAttributes = new DefaultAttributes();
    @Deprecated
    private int generation = 0;
    @Deprecated
    private String path;
    @Deprecated
    private boolean readable;
    @Deprecated
    private boolean writable;
    @Deprecated
    private String repositoryId;
    @Deprecated
    private long created;
    @Deprecated
    private long modified;
    @Deprecated
    private long storedLocally;
    @Deprecated
    private long lastTouched;
    @Deprecated
    private long lastRequested;
    @Deprecated
    private boolean expired;
    @Deprecated
    private String remoteUrl;
    @Deprecated
    private Map<String, String> attributes;

    @Override
    public Attributes getRepositoryItemAttributes() {
        return this.itemAttributes;
    }

    public void upgrade() {
        this.context = new RequestContext();
        this.itemAttributes = new DefaultAttributes();
        if (this.attributes != null) {
            this.getRepositoryItemAttributes().putAll(this.attributes);
        }
        this.getRepositoryItemAttributes().setGeneration(this.generation);
        this.getRepositoryItemAttributes().setPath(this.path);
        this.getRepositoryItemAttributes().setReadable(this.readable);
        this.getRepositoryItemAttributes().setWritable(this.writable);
        this.getRepositoryItemAttributes().setRepositoryId(this.repositoryId);
        this.getRepositoryItemAttributes().setCreated(this.created);
        this.getRepositoryItemAttributes().setModified(this.modified);
        this.getRepositoryItemAttributes().setStoredLocally(this.storedLocally);
        this.getRepositoryItemAttributes().setCheckedRemotely(this.lastTouched);
        this.getRepositoryItemAttributes().setLastRequested(this.lastRequested);
        this.getRepositoryItemAttributes().setExpired(this.expired);
        if (!Strings.isNullOrEmpty((String)this.remoteUrl)) {
            this.getRepositoryItemAttributes().setRemoteUrl(this.remoteUrl);
        }
    }

    @Deprecated
    private AbstractStorageItem() {
    }

    public AbstractStorageItem(ResourceStoreRequest request, boolean readable, boolean writable) {
        this();
        this.request = request.cloneAndDetach();
        this.context.setParentContext(request.getRequestContext());
        this.setPath(request.getRequestPath());
        this.setReadable(readable);
        this.setWritable(writable);
        this.setCreated(System.currentTimeMillis());
        this.setModified(this.getCreated());
    }

    public AbstractStorageItem(Repository repository, ResourceStoreRequest request, boolean readable, boolean writable) {
        this(request, readable, writable);
        this.store = repository;
        this.repositoryItemUid = repository.createUid(this.getPath());
        this.setRepositoryId(repository.getId());
    }

    public AbstractStorageItem(RepositoryRouter router, ResourceStoreRequest request, boolean readable, boolean writable) {
        this(request, readable, writable);
        this.store = router;
    }

    public ResourceStore getStore() {
        return this.store;
    }

    @Override
    public ResourceStoreRequest getResourceStoreRequest() {
        return this.request;
    }

    public void setResourceStoreRequest(ResourceStoreRequest request) {
        this.request = request;
        this.context = new RequestContext(request.getRequestContext());
    }

    @Override
    public RepositoryItemUid getRepositoryItemUid() {
        return this.repositoryItemUid;
    }

    @Override
    public void setRepositoryItemUid(RepositoryItemUid repositoryItemUid) {
        this.repositoryItemUid = repositoryItemUid;
        this.store = repositoryItemUid.getRepository();
        this.getRepositoryItemAttributes().setRepositoryId(repositoryItemUid.getRepository().getId());
        this.getRepositoryItemAttributes().setPath(repositoryItemUid.getPath());
    }

    @Override
    public String getRepositoryId() {
        return this.getRepositoryItemAttributes().getRepositoryId();
    }

    public void setRepositoryId(String repositoryId) {
        this.getRepositoryItemAttributes().setRepositoryId(repositoryId);
    }

    @Override
    public long getCreated() {
        return this.getRepositoryItemAttributes().getCreated();
    }

    public void setCreated(long created) {
        this.getRepositoryItemAttributes().setCreated(created);
    }

    @Override
    public long getModified() {
        return this.getRepositoryItemAttributes().getModified();
    }

    public void setModified(long modified) {
        this.getRepositoryItemAttributes().setModified(modified);
    }

    @Override
    public boolean isReadable() {
        return this.getRepositoryItemAttributes().isReadable();
    }

    public void setReadable(boolean readable) {
        this.getRepositoryItemAttributes().setReadable(readable);
    }

    @Override
    public boolean isWritable() {
        return this.getRepositoryItemAttributes().isWritable();
    }

    public void setWritable(boolean writable) {
        this.getRepositoryItemAttributes().setWritable(writable);
    }

    @Override
    public String getPath() {
        return this.getRepositoryItemAttributes().getPath();
    }

    public void setPath(String path) {
        this.getRepositoryItemAttributes().setPath(PathUtils.cleanUpTrailingSlash(path));
    }

    @Override
    public boolean isExpired() {
        return this.getRepositoryItemAttributes().isExpired();
    }

    @Override
    public void setExpired(boolean expired) {
        this.getRepositoryItemAttributes().setExpired(expired);
    }

    @Override
    public String getName() {
        return new File(this.getPath()).getName();
    }

    @Override
    public String getParentPath() {
        return PathUtils.getParentPath(this.getPath());
    }

    @Override
    public int getPathDepth() {
        return PathUtils.getPathDepth(this.getPath());
    }

    @Override
    public RequestContext getItemContext() {
        return this.context;
    }

    @Override
    public boolean isVirtual() {
        return this.getRepositoryItemUid() == null;
    }

    @Override
    public String getRemoteUrl() {
        return this.getRepositoryItemAttributes().getRemoteUrl();
    }

    public void setRemoteUrl(String remoteUrl) {
        this.getRepositoryItemAttributes().setRemoteUrl(remoteUrl);
    }

    @Override
    public long getStoredLocally() {
        return this.getRepositoryItemAttributes().getStoredLocally();
    }

    @Override
    public void setStoredLocally(long storedLocally) {
        this.getRepositoryItemAttributes().setStoredLocally(storedLocally);
    }

    @Override
    public long getRemoteChecked() {
        return this.getRepositoryItemAttributes().getCheckedRemotely();
    }

    @Override
    public void setRemoteChecked(long lastTouched) {
        this.getRepositoryItemAttributes().setCheckedRemotely(lastTouched);
    }

    @Override
    public long getLastRequested() {
        return this.getRepositoryItemAttributes().getLastRequested();
    }

    @Override
    public void setLastRequested(long lastRequested) {
        this.getRepositoryItemAttributes().setLastRequested(lastRequested);
    }

    public String toString() {
        if (this.isVirtual()) {
            return this.getPath();
        }
        return this.getRepositoryItemUid().toString();
    }
}

