/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.events;

import java.util.Map;
import org.sonatype.nexus.proxy.events.RepositoryEvent;
import org.sonatype.nexus.proxy.item.RepositoryItemUid;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.utils.RepositoryStringUtils;

public abstract class RepositoryItemEvent
extends RepositoryEvent {
    private final StorageItem item;
    private final Map<String, Object> itemContext;

    public RepositoryItemEvent(Repository repository, StorageItem item) {
        super(repository);
        this.item = item;
        this.itemContext = item.getItemContext().flatten();
    }

    public RepositoryItemUid getItemUid() {
        return this.item.getRepositoryItemUid();
    }

    public Map<String, Object> getItemContext() {
        return this.itemContext;
    }

    public StorageItem getItem() {
        return this.item;
    }

    @Override
    public String toString() {
        return String.format("%s(sender=%s, %s)", this.getClass().getSimpleName(), RepositoryStringUtils.getHumanizedNameString(this.getRepository()), this.getItem().getRepositoryItemUid().toString());
    }
}

