/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.events;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.sonatype.nexus.proxy.events.RepositoryEvent;
import org.sonatype.nexus.proxy.repository.GroupRepository;

public class RepositoryGroupMembersChangedEvent
extends RepositoryEvent {
    private final List<String> oldRepositoryMemberIds;
    private final List<String> newRepositoryMemberIds;
    private final List<String> removedRepositoryIds;
    private final List<String> addedRepositoryIds;
    private final List<String> reorderedRepositoryIds;
    private final Set<MemberChange> memberChangeSet;

    public RepositoryGroupMembersChangedEvent(GroupRepository repository, List<String> currentMemberIds, List<String> newMemberIds) {
        super(repository);
        this.oldRepositoryMemberIds = new ArrayList<String>(currentMemberIds);
        this.newRepositoryMemberIds = new ArrayList<String>(newMemberIds);
        this.removedRepositoryIds = new ArrayList<String>(this.oldRepositoryMemberIds);
        this.removedRepositoryIds.removeAll(this.newRepositoryMemberIds);
        this.addedRepositoryIds = new ArrayList<String>(this.newRepositoryMemberIds);
        this.addedRepositoryIds.removeAll(this.oldRepositoryMemberIds);
        this.reorderedRepositoryIds = new ArrayList<String>();
        ArrayList<String> currentTrimmed = new ArrayList<String>(this.oldRepositoryMemberIds);
        currentTrimmed.removeAll(this.removedRepositoryIds);
        currentTrimmed.removeAll(this.addedRepositoryIds);
        ArrayList<String> newTrimmed = new ArrayList<String>(this.newRepositoryMemberIds);
        newTrimmed.removeAll(this.removedRepositoryIds);
        newTrimmed.removeAll(this.addedRepositoryIds);
        if (!currentTrimmed.equals(newTrimmed) && currentTrimmed.size() > 0) {
            Iterator i1 = currentTrimmed.iterator();
            Iterator i2 = newTrimmed.iterator();
            while (i1.hasNext()) {
                String newEl;
                String oldEl = (String)i1.next();
                if (oldEl.equals(newEl = (String)i2.next())) continue;
                this.reorderedRepositoryIds.add(newEl);
            }
        }
        this.memberChangeSet = EnumSet.noneOf(MemberChange.class);
        if (!this.reorderedRepositoryIds.isEmpty()) {
            this.memberChangeSet.add(MemberChange.MEMBER_REORDERED);
        }
        if (!this.removedRepositoryIds.isEmpty()) {
            this.memberChangeSet.add(MemberChange.MEMBER_REMOVED);
        }
        if (!this.addedRepositoryIds.isEmpty()) {
            this.memberChangeSet.add(MemberChange.MEMBER_ADDED);
        }
    }

    public GroupRepository getGroupRepository() {
        return (GroupRepository)this.getEventSender();
    }

    public Set<MemberChange> getMemberChangeSet() {
        return this.memberChangeSet;
    }

    public List<String> getOldRepositoryMemberIds() {
        return Collections.unmodifiableList(this.oldRepositoryMemberIds);
    }

    public List<String> getNewRepositoryMemberIds() {
        return Collections.unmodifiableList(this.newRepositoryMemberIds);
    }

    public List<String> getRemovedRepositoryIds() {
        return Collections.unmodifiableList(this.removedRepositoryIds);
    }

    public List<String> getAddedRepositoryIds() {
        return Collections.unmodifiableList(this.addedRepositoryIds);
    }

    public List<String> getReorderedRepositoryIds() {
        return Collections.unmodifiableList(this.reorderedRepositoryIds);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{" + "repositoryId=" + this.getRepository().getId() + ", addedMembers=" + this.getAddedRepositoryIds() + ", removedMembers=" + this.getRemovedRepositoryIds() + ", reorderedMembers=" + this.getReorderedRepositoryIds() + '}';
    }

    public static enum MemberChange {
        MEMBER_ADDED,
        MEMBER_REMOVED,
        MEMBER_REORDERED;

    }
}

