/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.cache;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.events.EventSubscriber;
import org.sonatype.nexus.proxy.cache.CacheManager;
import org.sonatype.nexus.proxy.cache.PathCache;
import org.sonatype.nexus.proxy.events.RepositoryRegistryEventRemove;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.utils.RepositoryStringUtils;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Named
@Singleton
public class PathCacheEventInspector
extends ComponentSupport
implements EventSubscriber {
    private final CacheManager cacheManager;

    @Inject
    public PathCacheEventInspector(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Subscribe
    @AllowConcurrentEvents
    public void inspect(RepositoryRegistryEventRemove removedRepositoryEvent) {
        Repository removedRepository = removedRepositoryEvent.getRepository();
        PathCache pathCache = this.cacheManager.getPathCache(removedRepository.getId());
        if (this.log.isDebugEnabled()) {
            this.log.debug("Purging NFC PathCache of repository {}", (Object)RepositoryStringUtils.getHumanizedNameString(removedRepository));
        }
        pathCache.purge();
    }
}

