/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.cache;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.Statistics;
import org.sonatype.nexus.proxy.cache.AbstractPathCache;
import org.sonatype.nexus.proxy.cache.CacheStatistics;

public class EhCachePathCache
extends AbstractPathCache {
    private final String _repositoryId;
    private final Ehcache _ec;

    public EhCachePathCache(String repositoryId, Ehcache cache) {
        this._repositoryId = (String)Preconditions.checkNotNull((Object)repositoryId);
        this._ec = (Ehcache)Preconditions.checkNotNull((Object)cache);
    }

    protected String getRepositoryId() {
        return this._repositoryId;
    }

    protected Ehcache getEHCache() {
        return this._ec;
    }

    @Override
    public boolean doContains(String key) {
        return this.getEHCache().get((Serializable)((Object)key)) != null;
    }

    @Override
    public boolean doIsExpired(String key) {
        if (this.getEHCache().isKeyInCache((Object)key)) {
            Element el = this.getEHCache().get((Serializable)((Object)key));
            if (el != null) {
                return el.isExpired();
            }
            return true;
        }
        return false;
    }

    @Override
    public long doGetExpirationTime(String key) {
        Element el = this.getEHCache().get((Serializable)((Object)key));
        if (el != null) {
            return el.getExpirationTime();
        }
        return -1L;
    }

    @Override
    public void doPut(String key, Object element, int expiration) {
        Element el = new Element((Object)key, element);
        if (expiration > -1) {
            el.setTimeToLive(expiration);
        }
        this.getEHCache().put(el);
    }

    @Override
    public boolean doRemove(String key) {
        return this.getEHCache().remove((Serializable)((Object)key));
    }

    @Override
    public boolean removeWithChildren(String path) {
        List keys = this.getEHCache().getKeys();
        String keyToRemove = this.makeKeyFromPath(path);
        boolean removed = false;
        for (String key : keys) {
            if (!key.startsWith(keyToRemove)) continue;
            removed = this.getEHCache().remove((Serializable)((Object)key)) || removed;
        }
        return removed;
    }

    @Override
    public boolean doPurge() {
        return this.removeWithChildren("/");
    }

    @Override
    public CacheStatistics getStatistics() {
        Statistics stats = this.getEHCache().getStatistics();
        return new CacheStatistics(stats.getObjectCount(), stats.getCacheMisses(), stats.getCacheHits());
    }

    @Override
    public Collection<String> listKeysInCache() {
        this.getEHCache().evictExpiredElements();
        ArrayList<String> keys = new ArrayList<String>();
        String startsWithString = this.getKeyPrefix();
        for (String key : this.getEHCache().getKeys()) {
            if (!key.startsWith(startsWithString)) continue;
            keys.add(key.substring(startsWithString.length()));
        }
        return keys;
    }

    @Override
    protected String makeKeyFromPath(String path) {
        path = super.makeKeyFromPath(path);
        return this.getKeyPrefix() + path;
    }

    protected String getKeyPrefix() {
        return this.getRepositoryId() + ":";
    }
}

