/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.cache;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.Subscribe;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.proxy.cache.CacheManager;
import org.sonatype.nexus.proxy.cache.EhCachePathCache;
import org.sonatype.nexus.proxy.cache.PathCache;
import org.sonatype.nexus.proxy.events.NexusStoppedEvent;
import org.sonatype.sisu.goodies.common.ComponentSupport;
import org.sonatype.sisu.goodies.eventbus.EventBus;

@Named
@Singleton
public class EhCacheCacheManager
extends ComponentSupport
implements CacheManager {
    private final net.sf.ehcache.CacheManager cacheManager;
    public static final String SINGLE_PATH_CACHE_NAME = "nx-repository-path-cache";

    @Inject
    public EhCacheCacheManager(EventBus eventBus, net.sf.ehcache.CacheManager cacheManager) {
        eventBus.register((Object)this);
        this.cacheManager = (net.sf.ehcache.CacheManager)Preconditions.checkNotNull((Object)cacheManager);
    }

    @Override
    public synchronized PathCache getPathCache(String cache) {
        if (!this.cacheManager.cacheExists(SINGLE_PATH_CACHE_NAME)) {
            this.cacheManager.addCache(SINGLE_PATH_CACHE_NAME);
        }
        return new EhCachePathCache(cache, this.cacheManager.getEhcache(SINGLE_PATH_CACHE_NAME));
    }

    @Subscribe
    public void on(NexusStoppedEvent event) {
        this.cacheManager.shutdown();
    }
}

