/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.cache;

import org.sonatype.nexus.proxy.cache.PathCache;

public abstract class AbstractPathCache
implements PathCache {
    @Override
    public final boolean contains(String path) {
        return this.doContains(this.makeKeyFromPath(path));
    }

    @Override
    public final boolean isExpired(String path) {
        return this.doIsExpired(this.makeKeyFromPath(path));
    }

    @Override
    public final long getExpirationTime(String path) {
        return this.doGetExpirationTime(this.makeKeyFromPath(path));
    }

    @Override
    public final void put(String path, Object element) {
        this.doPut(this.makeKeyFromPath(path), element, -1);
    }

    @Override
    public final void put(String path, Object element, int expiration) {
        this.doPut(this.makeKeyFromPath(path), element, expiration);
    }

    @Override
    public final boolean remove(String path) {
        if (this.contains(path)) {
            return this.doRemove(this.makeKeyFromPath(path));
        }
        return false;
    }

    @Override
    public final boolean removeWithParents(String path) {
        boolean result = this.remove(path);
        int lastSlash = path.lastIndexOf("/");
        while (lastSlash > -1) {
            path = path.substring(0, lastSlash);
            boolean r = this.remove(path);
            result = result || r;
            lastSlash = path.lastIndexOf("/");
        }
        return result;
    }

    @Override
    public abstract boolean removeWithChildren(String var1);

    @Override
    public final boolean purge() {
        return this.doPurge();
    }

    protected String makeKeyFromPath(String path) {
        while (path.startsWith("/")) {
            path = path.substring(1);
        }
        while (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    protected abstract boolean doContains(String var1);

    protected abstract boolean doIsExpired(String var1);

    protected abstract long doGetExpirationTime(String var1);

    protected abstract void doPut(String var1, Object var2, int var3);

    protected abstract boolean doRemove(String var1);

    protected abstract boolean doPurge();
}

