/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.attributes.internal;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.sonatype.nexus.proxy.attributes.Attributes;

public class DefaultAttributes
implements Attributes {
    private final HashMap<String, String> defaults = new HashMap();
    private final HashMap<String, String> values = new HashMap();

    public DefaultAttributes() {
    }

    public DefaultAttributes(Map<String, String> m) {
        this();
        this.overlayMap(m);
    }

    @Override
    public boolean containsKey(String key) {
        return this.values.containsKey(key) || this.defaults.containsKey(key);
    }

    @Override
    public String get(String key) {
        if (this.values.containsKey(key)) {
            return this.values.get(key);
        }
        return this.defaults.get(key);
    }

    @Override
    public String put(String key, String value) {
        return this.values.put((String)Preconditions.checkNotNull((Object)key), (String)Preconditions.checkNotNull((Object)value));
    }

    @Override
    public String remove(String key) {
        String valuesPrev = this.values.remove(key);
        String defaultsPrev = this.defaults.remove(key);
        if (valuesPrev == null) {
            return defaultsPrev;
        }
        return valuesPrev;
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> map) {
        this.values.putAll(map);
    }

    protected int getInteger(String key, int defaultValue) {
        if (this.containsKey(key)) {
            return Integer.valueOf(this.get(key));
        }
        return defaultValue;
    }

    protected void setInteger(String key, int value) {
        this.put(key, Integer.toString(value));
    }

    protected long getLong(String key, long defaultValue) {
        if (this.containsKey(key)) {
            return Long.valueOf(this.get(key));
        }
        return defaultValue;
    }

    protected void setLong(String key, long value) {
        this.put(key, Long.toString(value));
    }

    protected boolean getBoolean(String key, boolean defaultValue) {
        if (this.containsKey(key)) {
            return Boolean.valueOf(this.get(key));
        }
        return defaultValue;
    }

    protected void setBoolean(String key, boolean value) {
        this.put(key, Boolean.toString(value));
    }

    protected String getString(String key, String defaultValue) {
        if (this.containsKey(key)) {
            return this.get(key);
        }
        return defaultValue;
    }

    protected void setString(String key, String value) {
        this.put(key, (String)Preconditions.checkNotNull((Object)value));
    }

    protected String getKeyForAttribute(String attributeName) {
        return new StringBuilder(32).append("storageItem-").append((String)Preconditions.checkNotNull((Object)attributeName)).toString();
    }

    protected void overlayMap(Map<String, String> map) {
        this.defaults.putAll(map);
        this.defaults.remove(this.getKeyForAttribute("length"));
    }

    @Override
    public void overlayAttributes(Attributes repositoryItemAttributes) {
        this.overlayMap(repositoryItemAttributes.asMap());
    }

    @Override
    public int getGeneration() {
        return this.getInteger(this.getKeyForAttribute("generation"), 0);
    }

    @Override
    public void setGeneration(int value) {
        this.setInteger(this.getKeyForAttribute("generation"), value);
    }

    @Override
    public void incrementGeneration() {
        this.setInteger(this.getKeyForAttribute("generation"), this.getGeneration() + 1);
    }

    @Override
    public String getPath() {
        return this.getString(this.getKeyForAttribute("path"), null);
    }

    @Override
    public void setPath(String value) {
        this.setString(this.getKeyForAttribute("path"), value);
    }

    @Override
    public boolean isReadable() {
        return this.getBoolean(this.getKeyForAttribute("readable"), true);
    }

    @Override
    public void setReadable(boolean value) {
        this.setBoolean(this.getKeyForAttribute("readable"), value);
    }

    @Override
    public boolean isWritable() {
        return this.getBoolean(this.getKeyForAttribute("writable"), true);
    }

    @Override
    public void setWritable(boolean value) {
        this.setBoolean(this.getKeyForAttribute("writable"), value);
    }

    @Override
    public String getRepositoryId() {
        return this.getString(this.getKeyForAttribute("repositoryId"), null);
    }

    @Override
    public void setRepositoryId(String value) {
        this.setString(this.getKeyForAttribute("repositoryId"), value);
    }

    @Override
    public long getCreated() {
        return this.getLong(this.getKeyForAttribute("created"), 0L);
    }

    @Override
    public void setCreated(long value) {
        this.setLong(this.getKeyForAttribute("created"), value);
    }

    @Override
    public long getModified() {
        return this.getLong(this.getKeyForAttribute("modified"), 0L);
    }

    @Override
    public void setModified(long value) {
        this.setLong(this.getKeyForAttribute("modified"), value);
    }

    @Override
    public long getStoredLocally() {
        return this.getLong(this.getKeyForAttribute("storedLocally"), 0L);
    }

    @Override
    public void setStoredLocally(long value) {
        this.setLong(this.getKeyForAttribute("storedLocally"), value);
    }

    @Override
    public long getCheckedRemotely() {
        return this.getLong(this.getKeyForAttribute("checkedRemotely"), 0L);
    }

    @Override
    public void setCheckedRemotely(long value) {
        this.setLong(this.getKeyForAttribute("checkedRemotely"), value);
    }

    @Override
    public long getLastRequested() {
        return this.getLong(this.getKeyForAttribute("lastRequested"), 0L);
    }

    @Override
    public void setLastRequested(long value) {
        this.setLong(this.getKeyForAttribute("lastRequested"), value);
    }

    @Override
    public boolean isExpired() {
        return this.getBoolean(this.getKeyForAttribute("expired"), false);
    }

    @Override
    public void setExpired(boolean value) {
        this.setBoolean(this.getKeyForAttribute("expired"), value);
    }

    @Override
    public String getRemoteUrl() {
        return this.getString(this.getKeyForAttribute("remoteUrl"), null);
    }

    @Override
    public void setRemoteUrl(String value) {
        this.setString(this.getKeyForAttribute("remoteUrl"), value);
    }

    @Override
    public Map<String, String> asMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.putAll(this.defaults);
        result.putAll(this.values);
        return Collections.unmodifiableMap(result);
    }
}

