/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.attributes.inspectors;

import com.google.common.io.ByteStreams;
import java.io.InputStream;
import java.security.MessageDigest;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.proxy.attributes.AbstractStorageItemInspector;
import org.sonatype.nexus.proxy.item.ChecksummingContentLocator;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.util.io.StreamSupport;

@Singleton
@Named
public class DigestCalculatingInspector
extends AbstractStorageItemInspector {
    @Deprecated
    public static String DIGEST_MD5_KEY = "digest.md5";
    public static String DIGEST_SHA1_KEY = "digest.sha1";

    @Override
    public boolean isHandled(StorageItem item) {
        if (item instanceof StorageFileItem) {
            return !this.maybeGetFromContext(item);
        }
        return false;
    }

    @Override
    public void processStorageItem(StorageItem item) throws Exception {
        if (item instanceof StorageFileItem) {
            StorageFileItem file = (StorageFileItem)item;
            ChecksummingContentLocator sha1cl = new ChecksummingContentLocator(file.getContentLocator(), MessageDigest.getInstance("SHA1"), "digest.sha1", item.getItemContext());
            ChecksummingContentLocator md5cl = new ChecksummingContentLocator(sha1cl, MessageDigest.getInstance("MD5"), "digest.md5", item.getItemContext());
            try (InputStream is = md5cl.getContent();){
                StreamSupport.copy(is, ByteStreams.nullOutputStream(), StreamSupport.BUFFER_SIZE);
            }
            this.maybeGetFromContext(item);
        }
    }

    protected boolean maybeGetFromContext(StorageItem item) {
        if (item.getItemContext().containsKey("digest.sha1")) {
            item.getRepositoryItemAttributes().put(DIGEST_SHA1_KEY, String.valueOf(item.getItemContext().get("digest.sha1")));
            item.getRepositoryItemAttributes().put(DIGEST_MD5_KEY, String.valueOf(item.getItemContext().get("digest.md5")));
            return true;
        }
        return false;
    }
}

