/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.attributes.inspectors;

import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.proxy.attributes.AbstractStorageItemInspector;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.item.StorageItem;

@Singleton
@Named
public class AuditingInspector
extends AbstractStorageItemInspector {
    @Override
    public boolean isHandled(StorageItem item) {
        if (item instanceof StorageFileItem) {
            StorageFileItem fitem = (StorageFileItem)item;
            this.addIfExistsButDontContains(fitem, "request.user");
            this.addIfExistsButDontContains(fitem, "request.address");
            this.addIfExistsButDontContains(fitem, "request.isConfidential");
        }
        return false;
    }

    @Override
    public void processStorageItem(StorageItem item) throws Exception {
    }

    private void addIfExistsButDontContains(StorageFileItem item, String contextKey) {
        Object val;
        if (item.getItemContext().containsKey(contextKey) && !item.getRepositoryItemAttributes().containsKey(contextKey) && (val = item.getItemContext().get(contextKey)) != null) {
            item.getRepositoryItemAttributes().put(contextKey, val.toString());
        }
    }
}

