/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.attributes;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.sonatype.nexus.proxy.attributes.Attributes;
import org.sonatype.nexus.proxy.attributes.InvalidInputException;
import org.sonatype.nexus.proxy.attributes.Marshaller;
import org.sonatype.nexus.proxy.attributes.internal.DefaultAttributes;

public class JacksonJSONMarshaller
implements Marshaller {
    private final ObjectMapper objectMapper = new ObjectMapper();

    @Override
    public void marshal(Attributes item, OutputStream outputStream) throws IOException {
        HashMap<String, String> attrs = new HashMap<String, String>(item.asMap());
        this.objectMapper.writeValue(outputStream, attrs);
        outputStream.flush();
    }

    @Override
    public Attributes unmarshal(InputStream inputStream) throws IOException, InvalidInputException {
        try {
            Map attributesMap = (Map)this.objectMapper.readValue(inputStream, (TypeReference)new TypeReference<Map<String, String>>(){});
            return new DefaultAttributes(attributesMap);
        }
        catch (JsonProcessingException e) {
            throw new InvalidInputException("Persisted attribute malformed!", e);
        }
        catch (CharConversionException e) {
            throw new InvalidInputException("Persisted attribute malformed!", e);
        }
    }

    public String toString() {
        return "JacksonJSON";
    }
}

