/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.attributes;

import com.google.common.base.Preconditions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.proxy.ItemNotFoundException;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.access.Action;
import org.sonatype.nexus.proxy.attributes.AbstractAttributeStorage;
import org.sonatype.nexus.proxy.attributes.AttributeStorage;
import org.sonatype.nexus.proxy.attributes.Attributes;
import org.sonatype.nexus.proxy.attributes.InvalidInputException;
import org.sonatype.nexus.proxy.attributes.JacksonJSONMarshaller;
import org.sonatype.nexus.proxy.attributes.Marshaller;
import org.sonatype.nexus.proxy.item.AbstractStorageItem;
import org.sonatype.nexus.proxy.item.ByteArrayContentLocator;
import org.sonatype.nexus.proxy.item.ContentLocator;
import org.sonatype.nexus.proxy.item.DefaultStorageFileItem;
import org.sonatype.nexus.proxy.item.RepositoryItemUid;
import org.sonatype.nexus.proxy.item.RepositoryItemUidLock;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.storage.UnsupportedStorageOperationException;

@Typed(value={AttributeStorage.class})
@Named(value="ls")
@Singleton
public class DefaultLSAttributeStorage
extends AbstractAttributeStorage
implements AttributeStorage {
    private static final String ATTRIBUTE_PATH_PREFIX = "/.nexus/attributes";
    private final Marshaller marshaller;

    @Inject
    public DefaultLSAttributeStorage() {
        this(new JacksonJSONMarshaller());
    }

    public DefaultLSAttributeStorage(Marshaller marshaller) {
        this.marshaller = (Marshaller)Preconditions.checkNotNull((Object)marshaller);
        this.log.info("Default FS AttributeStorage in place, using {} marshaller.", (Object)marshaller);
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean deleteAttributes(RepositoryItemUid uid) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Attributes getAttributes(RepositoryItemUid uid) throws IOException {
        RepositoryItemUidLock uidLock = uid.getLock();
        uidLock.lock(Action.read);
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Loading attributes on UID=" + uid.toString());
            }
            Attributes attributes = this.doGetAttributes(uid);
            return attributes;
        }
        finally {
            uidLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAttributes(RepositoryItemUid uid, Attributes attributes) throws IOException {
        RepositoryItemUidLock uidLock = uid.getLock();
        uidLock.lock(Action.create);
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Storing attributes on UID=" + uid.toString());
            }
            try {
                Attributes onDisk = this.doGetAttributes(uid);
                if (onDisk != null && onDisk.getGeneration() > attributes.getGeneration()) {
                    onDisk.overlayAttributes(attributes);
                    onDisk.setRepositoryId(uid.getRepository().getId());
                    onDisk.setPath(uid.getPath());
                    onDisk.setReadable(attributes.isReadable());
                    onDisk.setWritable(attributes.isWritable());
                    attributes = onDisk;
                }
                attributes.incrementGeneration();
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                this.marshaller.marshal(attributes, bos);
                Repository repository = uid.getRepository();
                DefaultStorageFileItem attributeItem = new DefaultStorageFileItem(repository, new ResourceStoreRequest(this.getAttributePath(repository, uid.getPath())), true, true, (ContentLocator)new ByteArrayContentLocator(bos.toByteArray(), "text/xml"));
                repository.getLocalStorage().storeItem(repository, attributeItem);
            }
            catch (UnsupportedStorageOperationException ex) {
                this.log.error("Got UnsupportedStorageOperationException during store of UID=" + uid.toString(), (Throwable)ex);
            }
        }
        finally {
            uidLock.unlock();
        }
    }

    protected String getAttributePath(Repository repository, String path) {
        if (path.startsWith("/")) {
            return ATTRIBUTE_PATH_PREFIX + path;
        }
        return "/.nexus/attributes/" + path;
    }

    protected Attributes doGetAttributes(RepositoryItemUid uid) throws IOException {
        boolean corrupt;
        Attributes result;
        block22: {
            result = null;
            corrupt = false;
            try {
                Repository repository = uid.getRepository();
                AbstractStorageItem attributeItemCandidate = repository.getLocalStorage().retrieveItem(repository, new ResourceStoreRequest(this.getAttributePath(repository, uid.getPath())));
                if (!(attributeItemCandidate instanceof StorageFileItem)) break block22;
                StorageFileItem attributeItem = (StorageFileItem)((Object)attributeItemCandidate);
                if (attributeItem.getLength() == 0L) {
                    throw new InvalidInputException("Attribute of " + uid + " is empty!");
                }
                try (InputStream attributeStream = attributeItem.getContentLocator().getContent();){
                    result = this.marshaller.unmarshal(attributeStream);
                }
                result.setRepositoryId(uid.getRepository().getId());
                result.setPath(uid.getPath());
                if (result.getCheckedRemotely() == 0L || result.getCheckedRemotely() == 1L) {
                    result.setCheckedRemotely(System.currentTimeMillis());
                    result.setExpired(true);
                }
                if (result.getLastRequested() == 0L) {
                    result.setLastRequested(System.currentTimeMillis());
                }
            }
            catch (InvalidInputException e) {
                if (this.log.isDebugEnabled()) {
                    this.log.info("Attributes of " + uid + " are corrupt, deleting it.", (Throwable)e);
                } else {
                    this.log.info("Attributes of " + uid + " are corrupt, deleting it.");
                }
                corrupt = true;
            }
            catch (IOException e) {
                this.log.warn("While reading attributes of " + uid + " we got IOException:", (Throwable)e);
                throw e;
            }
            catch (ItemNotFoundException e) {
                return null;
            }
        }
        if (corrupt) {
            this.deleteAttributes(uid);
        }
        return result;
    }
}

