/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.attributes;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.attributes.AttributeStorage;
import org.sonatype.nexus.proxy.attributes.Attributes;
import org.sonatype.nexus.proxy.attributes.AttributesHandler;
import org.sonatype.nexus.proxy.attributes.StorageItemInspector;
import org.sonatype.nexus.proxy.item.ContentLocator;
import org.sonatype.nexus.proxy.item.RepositoryItemUid;
import org.sonatype.nexus.proxy.item.StorageCollectionItem;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.item.uid.IsMetadataMaintainedAttribute;
import org.sonatype.nexus.proxy.repository.HostedRepository;
import org.sonatype.nexus.proxy.repository.ProxyRepository;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.repository.RepositoryKind;
import org.sonatype.nexus.util.SystemPropertiesHelper;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Named
@Singleton
public class DefaultAttributesHandler
extends ComponentSupport
implements AttributesHandler {
    private static final long LAST_REQUESTED_ATTRIBUTE_RESOLUTION_DEFAULT = 43200000L;
    private static final long LAST_REQUESTED_ATTRIBUTE_RESOLUTION = Math.abs(SystemPropertiesHelper.getLong("org.sonatype.nexus.proxy.attributes.DefaultAttributesHandler.lastRequested.resolution", 43200000L));
    private static final boolean LAST_REQUEST_ATTRIBUTE_ENABLED = SystemPropertiesHelper.getBoolean("org.sonatype.nexus.proxy.attributes.DefaultAttributesHandler.lastRequested.enabled", true);
    private static final boolean LAST_REQUEST_ATTRIBUTE_ENABLED_FOR_HOSTED = SystemPropertiesHelper.getBoolean("org.sonatype.nexus.proxy.attributes.DefaultAttributesHandler.lastRequested.enabled.hosted", LAST_REQUEST_ATTRIBUTE_ENABLED);
    private static final boolean LAST_REQUEST_ATTRIBUTE_ENABLED_FOR_PROXY = SystemPropertiesHelper.getBoolean("org.sonatype.nexus.proxy.attributes.DefaultAttributesHandler.lastRequested.enabled.proxy", LAST_REQUEST_ATTRIBUTE_ENABLED);
    private long lastRequestedResolution = LAST_REQUESTED_ATTRIBUTE_RESOLUTION;
    private final AttributeStorage attributeStorage;
    private final List<StorageItemInspector> itemInspectorList;

    @Inject
    public DefaultAttributesHandler(@Named(value="ls") AttributeStorage attributeStorage, List<StorageItemInspector> itemInspectorList) {
        this.attributeStorage = (AttributeStorage)Preconditions.checkNotNull((Object)attributeStorage);
        this.itemInspectorList = (List)Preconditions.checkNotNull(itemInspectorList);
    }

    @Override
    public AttributeStorage getAttributeStorage() {
        return this.attributeStorage;
    }

    public List<StorageItemInspector> getItemInspectorList() {
        return this.itemInspectorList;
    }

    @Override
    public boolean deleteAttributes(RepositoryItemUid uid) throws IOException {
        if (!this.isMetadataMaintained(uid)) {
            return false;
        }
        return this.getAttributeStorage().deleteAttributes(uid);
    }

    @Override
    public void fetchAttributes(StorageItem item) throws IOException {
        if (!this.isMetadataMaintained(item)) {
            return;
        }
        Attributes attributes = this.getAttributeStorage().getAttributes(item.getRepositoryItemUid());
        if (attributes != null) {
            item.getRepositoryItemAttributes().overlayAttributes(attributes);
        } else {
            ContentLocator is = null;
            if (item instanceof StorageFileItem && ((StorageFileItem)item).getContentLocator().isReusable()) {
                is = ((StorageFileItem)item).getContentLocator();
            }
            this.storeAttributes(item, is);
        }
    }

    @Override
    public void storeAttributes(StorageItem item) throws IOException {
        if (!this.isMetadataMaintained(item)) {
            return;
        }
        this.getAttributeStorage().putAttributes(item.getRepositoryItemUid(), item.getRepositoryItemAttributes());
    }

    @Override
    public void storeAttributes(StorageItem item, ContentLocator content) throws IOException {
        if (!this.isMetadataMaintained(item)) {
            return;
        }
        if (content != null) {
            if (item.getRemoteChecked() == 0L) {
                item.setRemoteChecked(System.currentTimeMillis());
            }
            if (item.getLastRequested() == 0L) {
                item.setLastRequested(System.currentTimeMillis());
            }
            item.setExpired(false);
            this.expandCustomItemAttributes(item, content);
        }
        this.storeAttributes(item);
    }

    @Override
    public void touchItemCheckedRemotely(long timestamp, StorageItem storageItem) throws IOException {
        if (!this.isMetadataMaintained(storageItem)) {
            return;
        }
        RepositoryItemUid uid = storageItem.getRepositoryItemUid();
        Attributes attributes = this.getAttributeStorage().getAttributes(uid);
        if (attributes != null) {
            attributes.setRepositoryId(uid.getRepository().getId());
            attributes.setPath(uid.getPath());
            attributes.setCheckedRemotely(timestamp);
            attributes.setExpired(false);
            this.getAttributeStorage().putAttributes(uid, attributes);
        }
    }

    @Override
    public void touchItemLastRequested(long timestamp, StorageItem storageItem) throws IOException {
        if (!this.isMetadataMaintained(storageItem)) {
            return;
        }
        this.touchItemLastRequested(timestamp, storageItem.getResourceStoreRequest(), storageItem.getRepositoryItemUid(), storageItem.getRepositoryItemAttributes());
    }

    protected boolean isMetadataMaintained(StorageItem item) {
        if (item instanceof StorageCollectionItem) {
            return false;
        }
        if (item.isVirtual()) {
            return false;
        }
        return this.isMetadataMaintained(item.getRepositoryItemUid());
    }

    protected boolean isMetadataMaintained(RepositoryItemUid uid) {
        Boolean isMetadataMaintained = (Boolean)uid.getAttributeValue(IsMetadataMaintainedAttribute.class);
        if (isMetadataMaintained != null) {
            return isMetadataMaintained;
        }
        return true;
    }

    protected void touchItemLastRequested(long timestamp, ResourceStoreRequest request, RepositoryItemUid uid, Attributes attributes) throws IOException {
        long diff;
        if (request.getRequestContext().containsKey("request.address") && this.isTouchLastRequestedEnabled(uid.getRepository()) && ((diff = timestamp - attributes.getLastRequested()) < 0L || diff > 0L && diff > this.lastRequestedResolution)) {
            attributes.setLastRequested(timestamp);
            this.getAttributeStorage().putAttributes(uid, attributes);
        }
    }

    protected boolean isTouchLastRequestedEnabled(Repository repository) throws IOException {
        boolean doTouch = LAST_REQUEST_ATTRIBUTE_ENABLED;
        RepositoryKind repositoryKind = repository.getRepositoryKind();
        if (repositoryKind != null) {
            if (repositoryKind.isFacetAvailable(HostedRepository.class)) {
                doTouch = LAST_REQUEST_ATTRIBUTE_ENABLED_FOR_HOSTED;
            } else if (repositoryKind.isFacetAvailable(ProxyRepository.class)) {
                doTouch = LAST_REQUEST_ATTRIBUTE_ENABLED_FOR_PROXY;
            }
        }
        return doTouch;
    }

    protected void expandCustomItemAttributes(StorageItem item, ContentLocator content) {
        for (StorageItemInspector inspector : this.getItemInspectorList()) {
            if (!inspector.isHandled(item)) continue;
            try {
                inspector.processStorageItem(item);
            }
            catch (Exception ex) {
                this.log.warn("Inspector {} throw exception during inspection of {}, continuing...", new Object[]{inspector.getClass(), item.getRepositoryItemUid(), ex});
            }
        }
    }
}

