/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.access;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.shiro.subject.Subject;
import org.sonatype.nexus.proxy.NoSuchRepositoryException;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.access.Action;
import org.sonatype.nexus.proxy.access.NexusItemAuthorizer;
import org.sonatype.nexus.proxy.registry.RepositoryRegistry;
import org.sonatype.nexus.proxy.repository.GroupRepository;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.targets.TargetMatch;
import org.sonatype.nexus.proxy.targets.TargetSet;
import org.sonatype.security.SecuritySystem;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Named
@Singleton
public class DefaultNexusItemAuthorizer
extends ComponentSupport
implements NexusItemAuthorizer {
    private final SecuritySystem securitySystem;
    private final RepositoryRegistry repoRegistry;

    @Inject
    public DefaultNexusItemAuthorizer(SecuritySystem securitySystem, RepositoryRegistry repoRegistry) {
        this.securitySystem = securitySystem;
        this.repoRegistry = repoRegistry;
    }

    @Override
    public boolean authorizePath(Repository repository, ResourceStoreRequest request, Action action) {
        TargetSet matched = repository.getTargetsForRequest(request);
        if (matched != null && this.authorizePath(matched, action)) {
            return true;
        }
        return this.authorizePathCascade(repository, request, action);
    }

    private boolean authorizePathCascade(Repository repository, ResourceStoreRequest request, Action action) {
        List<GroupRepository> groups = this.repoRegistry.getGroupsOfRepository(repository);
        for (GroupRepository group : groups) {
            if (!this.authorizePath(group, request, action)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean authorizePermission(String permission) {
        return this.isPermitted(Collections.singletonList(permission));
    }

    @Override
    public TargetSet getGroupsTargetSet(Repository repository, ResourceStoreRequest request) {
        TargetSet targetSet = new TargetSet();
        for (Repository group : this.getListOfGroups(repository.getId())) {
            TargetSet groupMatched = group.getTargetsForRequest(request);
            targetSet.addTargetSet(groupMatched);
            targetSet.addTargetSet(this.getGroupsTargetSet(group, request));
        }
        return targetSet;
    }

    @Override
    public boolean authorizePath(TargetSet matched, Action action) {
        if (matched.getMatchedRepositoryIds().size() > 0) {
            return this.isPermitted(this.getTargetPerms(matched, action));
        }
        return true;
    }

    @Override
    public boolean isViewable(String objectType, String objectId) {
        return this.authorizePermission("nexus:view:" + objectType + ":" + objectId);
    }

    protected List<Repository> getListOfGroups(String repositoryId) {
        ArrayList<Repository> groups = new ArrayList<Repository>();
        List<String> groupIds = this.repoRegistry.getGroupsOfRepository(repositoryId);
        for (String groupId : groupIds) {
            try {
                groups.add(this.repoRegistry.getRepository(groupId));
            }
            catch (NoSuchRepositoryException noSuchRepositoryException) {}
        }
        return groups;
    }

    protected List<String> getTargetPerms(TargetSet matched, Action action) {
        ArrayList<String> perms = new ArrayList<String>(matched.getMatches().size());
        for (TargetMatch match : matched.getMatches()) {
            perms.add("nexus:target:" + match.getTarget().getId() + ":" + match.getRepository().getId() + ":" + (Object)((Object)action));
        }
        return perms;
    }

    protected boolean isPermitted(List<String> perms) {
        boolean trace = this.log.isTraceEnabled();
        Subject subject = this.securitySystem.getSubject();
        if (trace) {
            this.log.trace("Subject: {}", (Object)subject);
        }
        if (subject == null) {
            if (trace) {
                this.log.trace("Subject is not authenticated; rejecting");
            }
            return false;
        }
        if (trace) {
            this.log.trace("Checking if subject '{}' has one of these permissions: {}", subject.getPrincipal(), perms);
        }
        for (String perm : perms) {
            if (!subject.isPermitted(perm)) continue;
            if (trace) {
                this.log.trace("Subject '{}' has permission: {}; allowing", subject.getPrincipal(), (Object)perm);
            }
            return true;
        }
        if (trace) {
            this.log.trace("Subject '{}' is missing required permissions; rejecting", subject.getPrincipal());
        }
        return false;
    }
}

