/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.access;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.proxy.AccessDeniedException;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.access.AccessManager;
import org.sonatype.nexus.proxy.access.Action;
import org.sonatype.nexus.proxy.access.NexusItemAuthorizer;
import org.sonatype.nexus.proxy.repository.Repository;

@Named
@Singleton
public class DefaultAccessManager
implements AccessManager {
    private final NexusItemAuthorizer nexusItemAuthorizer;

    @Inject
    public DefaultAccessManager(NexusItemAuthorizer nexusItemAuthorizer) {
        this.nexusItemAuthorizer = nexusItemAuthorizer;
    }

    @Override
    public void decide(Repository repository, ResourceStoreRequest request, Action action) throws AccessDeniedException {
        if (!request.getRequestContext().containsKey("request.authorized") && !this.nexusItemAuthorizer.authorizePath(repository, request, action)) {
            throw new AccessDeniedException("Access denied on repository ID='" + repository.getId() + "', path='" + request.getRequestPath() + "', action='" + (Object)((Object)action) + "'!");
        }
    }
}

