/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.sonatype.nexus.proxy.RequestContext;
import org.sonatype.nexus.proxy.item.RepositoryItemUid;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.repository.Repository;

public class ResourceStoreRequest {
    private String requestPath;
    private final RequestContext requestContext;
    private final Stack<String> pathStack;
    private final List<String> processedRepositories;
    private final Map<String, List<String>> appliedMappings;

    public ResourceStoreRequest(String requestPath, boolean localOnly, boolean remoteOnly) {
        this.requestPath = requestPath;
        this.pathStack = new Stack();
        this.processedRepositories = new ArrayList<String>();
        this.appliedMappings = new HashMap<String, List<String>>();
        this.requestContext = new RequestContext();
        this.requestContext.setRequestLocalOnly(localOnly);
        this.requestContext.setRequestRemoteOnly(remoteOnly);
    }

    public ResourceStoreRequest(String requestPath, boolean localOnly) {
        this(requestPath, localOnly, false);
    }

    public ResourceStoreRequest(String requestPath) {
        this(requestPath, false, false);
    }

    public ResourceStoreRequest(RepositoryItemUid uid, boolean localOnly) {
        this(uid.getPath(), localOnly, false);
    }

    public ResourceStoreRequest(StorageItem item) {
        this(item.getRepositoryItemUid().getPath(), true, false);
        this.getRequestContext().setParentContext(item.getItemContext());
    }

    public ResourceStoreRequest(ResourceStoreRequest request) {
        this(request.getRequestPath(), true, false);
        this.getRequestContext().setParentContext(request.getRequestContext());
    }

    public RequestContext getRequestContext() {
        return this.requestContext;
    }

    public String getRequestPath() {
        return this.requestPath;
    }

    public ResourceStoreRequest setRequestPath(String requestPath) {
        this.requestPath = requestPath;
        return this;
    }

    public void pushRequestPath(String requestPath) {
        this.pathStack.push(this.requestPath);
        this.requestPath = requestPath;
    }

    public String popRequestPath() {
        this.requestPath = this.pathStack.pop();
        return this.getRequestPath();
    }

    public boolean isRequestLocalOnly() {
        return this.getRequestContext().isRequestLocalOnly();
    }

    public ResourceStoreRequest setRequestLocalOnly(boolean requestLocalOnly) {
        this.getRequestContext().setRequestLocalOnly(requestLocalOnly);
        return this;
    }

    public boolean isRequestRemoteOnly() {
        return this.getRequestContext().isRequestRemoteOnly();
    }

    public ResourceStoreRequest setRequestRemoteOnly(boolean requestRemoteOnly) {
        this.getRequestContext().setRequestRemoteOnly(requestRemoteOnly);
        return this;
    }

    public boolean isRequestGroupLocalOnly() {
        return this.getRequestContext().isRequestGroupLocalOnly();
    }

    public boolean isRequestGroupMembersOnly() {
        return this.getRequestContext().isRequestGroupMembersOnly();
    }

    public ResourceStoreRequest setRequestAsExpired(boolean asExpired) {
        this.getRequestContext().setRequestAsExpired(asExpired);
        return this;
    }

    public boolean isRequestAsExpired() {
        return this.getRequestContext().isRequestAsExpired();
    }

    public ResourceStoreRequest setRequestGroupLocalOnly(boolean requestGroupLocal) {
        this.getRequestContext().setRequestGroupLocalOnly(requestGroupLocal);
        return this;
    }

    public ResourceStoreRequest setRequestGroupMembersOnly(boolean requestGroupMembers) {
        this.getRequestContext().setRequestGroupMembersOnly(requestGroupMembers);
        return this;
    }

    public List<String> getProcessedRepositories() {
        return Collections.unmodifiableList(this.processedRepositories);
    }

    public void addProcessedRepository(String repositoryId) {
        this.processedRepositories.add((String)Preconditions.checkNotNull((Object)repositoryId));
    }

    public boolean isConditional() {
        return this.getRequestContext().isConditional();
    }

    public long getIfModifiedSince() {
        return this.getRequestContext().getIfModifiedSince();
    }

    public ResourceStoreRequest setIfModifiedSince(long ifModifiedSince) {
        this.getRequestContext().setIfModifiedSince(ifModifiedSince);
        return this;
    }

    public String getIfNoneMatch() {
        return this.getRequestContext().getIfNoneMatch();
    }

    public ResourceStoreRequest setIfNoneMatch(String tag) {
        this.getRequestContext().setIfNoneMatch(tag);
        return this;
    }

    public String getRequestUrl() {
        return this.getRequestContext().getRequestUrl();
    }

    public ResourceStoreRequest setRequestUrl(String url) {
        this.getRequestContext().setRequestUrl(url);
        return this;
    }

    public boolean isExternal() {
        return this.getRequestContext().isRequestIsExternal();
    }

    public ResourceStoreRequest setExternal(boolean external) {
        this.getRequestContext().setRequestIsExternal(external);
        return this;
    }

    public void addAppliedMappingsList(Repository repository, List<String> mappingList) {
        this.appliedMappings.put(repository.getId(), mappingList);
    }

    public Map<String, List<String>> getAppliedMappings() {
        return this.appliedMappings;
    }

    public ResourceStoreRequest cloneAndDetach() {
        ResourceStoreRequest result = new ResourceStoreRequest(this.getRequestPath());
        result.requestContext.setParentContext(null);
        for (Map.Entry<String, Object> entry : this.requestContext.flatten().entrySet()) {
            result.requestContext.put(entry.getKey(), entry.getValue());
        }
        result.pathStack.clear();
        result.processedRepositories.clear();
        result.processedRepositories.addAll(this.processedRepositories);
        result.appliedMappings.clear();
        result.appliedMappings.putAll(this.appliedMappings);
        return result;
    }

    public String toString() {
        return "ResourceStoreRequest{requestPath='" + this.requestPath + '\'' + ", requestContext=" + this.requestContext + ", pathStack=" + this.pathStack + ", processedRepositories=" + this.processedRepositories + ", appliedMappings=" + this.appliedMappings + '}';
    }
}

