/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Stack;
import org.codehaus.plexus.util.StringUtils;

public class RequestContext {
    public static final String CTX_REQUEST_URL = "request.url";
    public static final String CTX_REQUEST_IS_EXTERNAL = "request.external";
    public static final String CTX_LOCAL_ONLY_FLAG = "request.localOnly";
    public static final String CTX_REMOTE_ONLY_FLAG = "request.remoteOnly";
    public static final String CTX_GROUP_LOCAL_ONLY_FLAG = "request.groupLocalOnly";
    public static final String CTX_GROUP_MEMEBRS_ONLY_FLAG = "request.groupMembersOnly";
    public static final String CTX_AS_EXPIRED_FLAG = "request.asExpired";
    public static final String CTX_CONDITION_IF_MODIFIED_SINCE = "request.condition.ifModifiedSince";
    public static final String CTX_CONDITION_IF_NONE_MATCH = "request.condition.ifNoneMatch";
    public static final String CTX_AUTH_CHECK_ONLY = "request.auth.check.only";
    private RequestContext parent;
    private final HashMap<String, Object> delegate;

    public RequestContext() {
        this(null);
    }

    public RequestContext(RequestContext parent) {
        this.setParentContext(parent);
        this.delegate = Maps.newHashMap();
    }

    public RequestContext getParentContext() {
        return this.parent;
    }

    public void setParentContext(RequestContext context) {
        if (context != null) {
            if (this == context) {
                throw new IllegalArgumentException("The context cannot be parent of itself! The parent instance cannot equals to this instance!");
            }
            for (RequestContext otherParentContext = context.getParentContext(); otherParentContext != null; otherParentContext = otherParentContext.getParentContext()) {
                if (this != otherParentContext) continue;
                throw new IllegalArgumentException("The context cannot be an ancestor of itself! Cycle detected!");
            }
        }
        this.parent = context;
    }

    public Object get(Object key, boolean fallBackToParent) {
        if (this.containsKey(key, false)) {
            return this.delegate.get(key);
        }
        if (fallBackToParent && this.getParentContext() != null && this.getParentContext() != this) {
            return this.getParentContext().get(key);
        }
        return null;
    }

    public boolean containsKey(Object key, boolean fallBackToParent) {
        boolean result = this.delegate.containsKey(key);
        if (fallBackToParent && !result && this.getParentContext() != null && this.getParentContext() != this) {
            result = this.getParentContext().containsKey(key);
        }
        return result;
    }

    public Object get(Object key) {
        return this.get(key, true);
    }

    public boolean containsKey(Object key) {
        return this.containsKey(key, true);
    }

    public Object put(String key, Object value) {
        return this.delegate.put(key, value);
    }

    @Deprecated
    public Object put(Object key, Object value) {
        return this.delegate.put((String)key, value);
    }

    public Object remove(Object key) {
        return this.delegate.remove(key);
    }

    protected void checkLocalRemoteExpiredFlags() throws IllegalArgumentException {
        HashSet<String> enabledFlags = new HashSet<String>();
        if (this.isRequestLocalOnly()) {
            enabledFlags.add("localOnly");
        }
        if (this.isRequestRemoteOnly()) {
            enabledFlags.add("remoteOnly");
        }
        if (this.isRequestAsExpired()) {
            enabledFlags.add("asExpired");
        }
        if (enabledFlags.size() > 1) {
            throw new IllegalArgumentException("Only one of the \"localOnly\", \"remoteOnly\" and \"asExpired\" might be enabled (set to true), but enabled ones are: " + enabledFlags);
        }
    }

    public boolean isRequestLocalOnly() {
        if (this.containsKey(CTX_LOCAL_ONLY_FLAG)) {
            return (Boolean)this.get(CTX_LOCAL_ONLY_FLAG);
        }
        return false;
    }

    public void setRequestLocalOnly(boolean requestLocalOnly) {
        this.put(CTX_LOCAL_ONLY_FLAG, (Object)requestLocalOnly);
        this.checkLocalRemoteExpiredFlags();
    }

    public boolean isRequestRemoteOnly() {
        if (this.containsKey(CTX_REMOTE_ONLY_FLAG)) {
            return (Boolean)this.get(CTX_REMOTE_ONLY_FLAG);
        }
        return false;
    }

    public void setRequestRemoteOnly(boolean requestRemoteOnly) {
        this.put(CTX_REMOTE_ONLY_FLAG, (Object)requestRemoteOnly);
        this.checkLocalRemoteExpiredFlags();
    }

    public boolean isRequestGroupLocalOnly() {
        if (this.containsKey(CTX_GROUP_LOCAL_ONLY_FLAG)) {
            return (Boolean)this.get(CTX_GROUP_LOCAL_ONLY_FLAG);
        }
        return false;
    }

    public void setRequestGroupLocalOnly(boolean requestGroupLocal) {
        this.put(CTX_GROUP_LOCAL_ONLY_FLAG, (Object)requestGroupLocal);
    }

    public boolean isRequestGroupMembersOnly() {
        if (this.containsKey(CTX_GROUP_MEMEBRS_ONLY_FLAG)) {
            return (Boolean)this.get(CTX_GROUP_MEMEBRS_ONLY_FLAG);
        }
        return false;
    }

    public void setRequestGroupMembersOnly(boolean requestGroupMembers) {
        this.put(CTX_GROUP_MEMEBRS_ONLY_FLAG, (Object)requestGroupMembers);
    }

    public boolean isRequestAsExpired() {
        if (this.containsKey(CTX_AS_EXPIRED_FLAG)) {
            return (Boolean)this.get(CTX_AS_EXPIRED_FLAG);
        }
        return false;
    }

    public void setRequestAsExpired(boolean asExpired) {
        this.put(CTX_AS_EXPIRED_FLAG, (Object)asExpired);
        this.checkLocalRemoteExpiredFlags();
    }

    public boolean isConditional() {
        return this.containsKey(CTX_CONDITION_IF_MODIFIED_SINCE) || this.containsKey(CTX_CONDITION_IF_NONE_MATCH);
    }

    public long getIfModifiedSince() {
        if (this.containsKey(CTX_CONDITION_IF_MODIFIED_SINCE)) {
            return (Long)this.get(CTX_CONDITION_IF_MODIFIED_SINCE);
        }
        return 0L;
    }

    public void setIfModifiedSince(long ifModifiedSince) {
        if (ifModifiedSince != 0L) {
            this.put(CTX_CONDITION_IF_MODIFIED_SINCE, (Object)ifModifiedSince);
        } else {
            this.remove(CTX_CONDITION_IF_MODIFIED_SINCE);
        }
    }

    public String getIfNoneMatch() {
        return (String)this.get(CTX_CONDITION_IF_NONE_MATCH);
    }

    public void setIfNoneMatch(String tag) {
        if (!StringUtils.isEmpty((String)tag)) {
            this.put(CTX_CONDITION_IF_NONE_MATCH, (Object)tag);
        } else {
            this.remove(CTX_CONDITION_IF_NONE_MATCH);
        }
    }

    public String getRequestUrl() {
        return (String)this.get(CTX_REQUEST_URL);
    }

    public void setRequestUrl(String url) {
        if (!StringUtils.isBlank((String)url)) {
            this.put(CTX_REQUEST_URL, (Object)url);
        } else {
            this.remove(CTX_REQUEST_URL);
        }
    }

    public boolean isRequestIsExternal() {
        if (this.containsKey(CTX_REQUEST_IS_EXTERNAL)) {
            return (Boolean)this.get(CTX_REQUEST_IS_EXTERNAL);
        }
        return false;
    }

    public void setRequestIsExternal(boolean external) {
        this.put(CTX_REQUEST_IS_EXTERNAL, (Object)external);
    }

    public Map<String, Object> flatten() {
        RequestContext ctx;
        HashMap<String, Object> result = new HashMap<String, Object>();
        Stack<RequestContext> stack = new Stack<RequestContext>();
        for (ctx = this; ctx != null; ctx = ctx.getParentContext()) {
            stack.push(ctx);
        }
        while (!stack.isEmpty()) {
            ctx = (RequestContext)stack.pop();
            for (Map.Entry<String, Object> entry : ctx.delegate.entrySet()) {
                result.put(entry.getKey(), entry.getValue());
            }
        }
        return result;
    }

    public String toString() {
        return "RequestContext{this=" + super.toString() + ", parent=" + this.parent + '}';
    }
}

