/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy;

import com.google.common.base.Preconditions;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.utils.RepositoryStringUtils;
import org.sonatype.sisu.goodies.common.FormatTemplate;
import org.sonatype.sisu.goodies.common.SimpleFormat;

public class ItemNotFoundException
extends Exception {
    private static final long serialVersionUID = -4964273361722823796L;
    private final ItemNotFoundReason reason;

    public static ItemNotFoundReason reasonFor(ResourceStoreRequest request, String message, Object ... params) {
        return new ItemNotFoundReason(SimpleFormat.template((String)message, (Object[])params), request);
    }

    public static ItemNotFoundInRepositoryReason reasonFor(ResourceStoreRequest request, Repository repository, String message, Object ... params) {
        return new ItemNotFoundInRepositoryReason(SimpleFormat.template((String)message, (Object[])params), request, repository);
    }

    @Deprecated
    private static ItemNotFoundReason legacySupport(String message, ResourceStoreRequest request, Repository repository) {
        if (repository != null) {
            return new ItemNotFoundInRepositoryReason(SimpleFormat.template((String)message, (Object[])new Object[0]), request, repository);
        }
        return new ItemNotFoundReason(SimpleFormat.template((String)message, (Object[])new Object[0]), request);
    }

    public ItemNotFoundException(ItemNotFoundReason reason) {
        this(reason, null);
    }

    public ItemNotFoundException(ItemNotFoundReason reason, Throwable cause) {
        super(reason.getMessage(), cause);
        this.reason = reason;
    }

    public ItemNotFoundReason getReason() {
        return this.reason;
    }

    @Deprecated
    public ItemNotFoundException(ResourceStoreRequest request) {
        this(request, null, null);
    }

    @Deprecated
    public ItemNotFoundException(ResourceStoreRequest request, Repository repository) {
        this(request, repository, null);
    }

    @Deprecated
    public ItemNotFoundException(ResourceStoreRequest request, Repository repository, Throwable cause) {
        this(repository != null ? "Item not found for request \"" + String.valueOf(request) + "\" in repository \"" + RepositoryStringUtils.getHumanizedNameString(repository) + "\"!" : "Item not found for request \"" + String.valueOf(request) + "\"!", request, repository, cause);
    }

    @Deprecated
    private ItemNotFoundException(String message, ResourceStoreRequest request, Repository repository, Throwable cause) {
        this(ItemNotFoundException.legacySupport(message, request, repository), cause);
    }

    public static class ItemNotFoundInRepositoryReason
    extends ItemNotFoundReason {
        private final Repository repository;

        public ItemNotFoundInRepositoryReason(FormatTemplate message, ResourceStoreRequest resourceStoreRequest, Repository repository) {
            super(message, resourceStoreRequest);
            this.repository = (Repository)Preconditions.checkNotNull((Object)repository);
        }

        public Repository getRepository() {
            return this.repository;
        }
    }

    public static class ItemNotFoundReason {
        private final FormatTemplate message;
        private final ResourceStoreRequest resourceStoreRequest;

        public ItemNotFoundReason(FormatTemplate message, ResourceStoreRequest resourceStoreRequest) {
            this.message = (FormatTemplate)Preconditions.checkNotNull((Object)message);
            this.resourceStoreRequest = ((ResourceStoreRequest)Preconditions.checkNotNull((Object)resourceStoreRequest)).cloneAndDetach();
        }

        public String getMessage() {
            return this.message.toString();
        }

        public ResourceStoreRequest getResourceStoreRequest() {
            return this.resourceStoreRequest;
        }
    }
}

