/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.repository;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.sonatype.nexus.plugins.repository.AbstractNexusPluginRepository;
import org.sonatype.nexus.plugins.repository.NoSuchPluginRepositoryArtifactException;
import org.sonatype.nexus.plugins.repository.PluginRepositoryArtifact;
import org.sonatype.plugin.metadata.GAVCoordinate;
import org.sonatype.plugins.model.PluginMetadata;

@Named(value="xml")
@Singleton
@Deprecated
class XmlNexusPluginRepository
extends AbstractNexusPluginRepository {
    static final String ID = "xml";
    private final Map<GAVCoordinate, PluginMetadata> plugins;
    private final Map<GAVCoordinate, PluginRepositoryArtifact> artifacts;

    @Inject
    public XmlNexusPluginRepository(@Named(value="${xml-plugin-repository}") @Nullable File pluginRepositoryXml) throws IOException, XmlPullParserException {
        LinkedHashMap<GAVCoordinate, PluginMetadata> plugins = new LinkedHashMap<GAVCoordinate, PluginMetadata>();
        LinkedHashMap<GAVCoordinate, PluginRepositoryArtifact> artifacts = new LinkedHashMap<GAVCoordinate, PluginRepositoryArtifact>();
        if (pluginRepositoryXml != null) {
            Xpp3Dom dom = Xpp3DomBuilder.build((Reader)ReaderFactory.newXmlReader((File)pluginRepositoryXml));
            Xpp3Dom artifactsDom = dom.getChild("artifacts");
            for (Xpp3Dom artifactDom : artifactsDom.getChildren("artifact")) {
                boolean plugin;
                String type = this.getChildText(artifactDom, "type");
                if ("nexus-plugin".equals(type)) {
                    plugin = true;
                    type = null;
                } else {
                    plugin = false;
                }
                String location = artifactDom.getChild("location").getValue();
                String groupId = artifactDom.getChild("groupId").getValue();
                String artifactId = artifactDom.getChild("artifactId").getValue();
                String version = artifactDom.getChild("version").getValue();
                String classifier = this.getChildText(artifactDom, "classifier");
                GAVCoordinate gav = new GAVCoordinate(groupId, artifactId, version, classifier, type);
                File file = new File(location).getCanonicalFile();
                artifacts.put(gav, new PluginRepositoryArtifact(gav, file, this));
                if (!plugin) continue;
                try {
                    PluginMetadata metadata = this.getPluginMetadata(new File(file, "META-INF/nexus/plugin.xml").toURI().toURL());
                    plugins.put(new GAVCoordinate(groupId, artifactId, version, classifier, type), metadata);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        this.plugins = Collections.unmodifiableMap(plugins);
        this.artifacts = Collections.unmodifiableMap(artifacts);
    }

    private String getChildText(Xpp3Dom dom, String childName) {
        Xpp3Dom child = dom.getChild(childName);
        return child != null ? child.getValue() : null;
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public Map<GAVCoordinate, PluginMetadata> findAvailablePlugins() {
        return this.plugins;
    }

    @Override
    public PluginRepositoryArtifact resolveArtifact(GAVCoordinate gav) throws NoSuchPluginRepositoryArtifactException {
        PluginRepositoryArtifact artifact = this.artifacts.get(gav);
        if (artifact == null) {
            throw new NoSuchPluginRepositoryArtifactException(this, gav);
        }
        return artifact;
    }

    @Override
    public PluginRepositoryArtifact resolveDependencyArtifact(PluginRepositoryArtifact plugin, GAVCoordinate gav) throws NoSuchPluginRepositoryArtifactException {
        return this.resolveArtifact(gav);
    }

    @Override
    public PluginMetadata getPluginMetadata(GAVCoordinate gav) throws NoSuchPluginRepositoryArtifactException {
        PluginMetadata metadata = this.plugins.get(gav);
        if (metadata == null) {
            throw new NoSuchPluginRepositoryArtifactException(this, gav);
        }
        return metadata;
    }
}

