/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.repository;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.plugins.repository.NexusPluginRepository;
import org.sonatype.nexus.plugins.repository.NexusPluginRepositoryComparator;
import org.sonatype.nexus.plugins.repository.NoSuchPluginRepositoryArtifactException;
import org.sonatype.nexus.plugins.repository.PluginRepositoryArtifact;
import org.sonatype.plugin.metadata.GAVCoordinate;
import org.sonatype.plugins.model.PluginMetadata;

@Named
@Singleton
@Deprecated
final class DefaultPluginRepositoryManager
implements NexusPluginRepository {
    private static final Comparator<NexusPluginRepository> REPOSITORY_COMPARATOR = new NexusPluginRepositoryComparator();
    @Inject
    private Map<String, NexusPluginRepository> repositoryMap;

    DefaultPluginRepositoryManager() {
    }

    @Override
    public String getId() {
        return null;
    }

    @Override
    public int getPriority() {
        return -1;
    }

    @Override
    public Map<GAVCoordinate, PluginMetadata> findAvailablePlugins() {
        HashMap<GAVCoordinate, PluginMetadata> installedPlugins = new HashMap<GAVCoordinate, PluginMetadata>();
        for (NexusPluginRepository r : this.getRepositories(true)) {
            installedPlugins.putAll(r.findAvailablePlugins());
        }
        return installedPlugins;
    }

    @Override
    public PluginRepositoryArtifact resolveArtifact(GAVCoordinate gav) throws NoSuchPluginRepositoryArtifactException {
        for (NexusPluginRepository r : this.getRepositories(false)) {
            try {
                return r.resolveArtifact(gav);
            }
            catch (NoSuchPluginRepositoryArtifactException noSuchPluginRepositoryArtifactException) {
            }
        }
        throw new NoSuchPluginRepositoryArtifactException(null, gav);
    }

    @Override
    public PluginRepositoryArtifact resolveDependencyArtifact(PluginRepositoryArtifact plugin, GAVCoordinate gav) throws NoSuchPluginRepositoryArtifactException {
        try {
            return plugin.getNexusPluginRepository().resolveDependencyArtifact(plugin, gav);
        }
        catch (NoSuchPluginRepositoryArtifactException noSuchPluginRepositoryArtifactException) {
            for (NexusPluginRepository r : this.getRepositories(false)) {
                try {
                    if (r == plugin.getNexusPluginRepository()) continue;
                    return r.resolveDependencyArtifact(plugin, gav);
                }
                catch (NoSuchPluginRepositoryArtifactException noSuchPluginRepositoryArtifactException2) {
                    // empty catch block
                }
            }
            throw new NoSuchPluginRepositoryArtifactException(null, gav);
        }
    }

    @Override
    public PluginMetadata getPluginMetadata(GAVCoordinate gav) throws NoSuchPluginRepositoryArtifactException {
        for (NexusPluginRepository r : this.getRepositories(false)) {
            try {
                return r.getPluginMetadata(gav);
            }
            catch (NoSuchPluginRepositoryArtifactException noSuchPluginRepositoryArtifactException) {
            }
        }
        throw new NoSuchPluginRepositoryArtifactException(null, gav);
    }

    private NexusPluginRepository[] getRepositories(boolean reverse) {
        TreeSet<NexusPluginRepository> sortedRepositories = reverse ? new TreeSet<NexusPluginRepository>(Collections.reverseOrder(REPOSITORY_COMPARATOR)) : new TreeSet<NexusPluginRepository>(REPOSITORY_COMPARATOR);
        for (NexusPluginRepository repo : this.repositoryMap.values()) {
            if (repo == this) continue;
            sortedRepositories.add(repo);
        }
        return sortedRepositories.toArray(new NexusPluginRepository[sortedRepositories.size()]);
    }
}

