/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.repository;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.nexus.plugins.repository.AbstractNexusPluginRepository;
import org.sonatype.nexus.plugins.repository.NoSuchPluginRepositoryArtifactException;
import org.sonatype.nexus.plugins.repository.PluginRepositoryArtifact;
import org.sonatype.nexus.proxy.maven.gav.Gav;
import org.sonatype.nexus.proxy.maven.packaging.ArtifactPackagingMapper;
import org.sonatype.plugin.metadata.GAVCoordinate;
import org.sonatype.plugins.model.PluginMetadata;

@Deprecated
public abstract class AbstractFileNexusPluginRepository
extends AbstractNexusPluginRepository {
    private static final String PLUGIN_XML = "META-INF/nexus/plugin.xml";
    @Inject
    private ArtifactPackagingMapper packagingMapper;
    private static final String SNAPSHOT_TIMESTAMP_FILE_PATTERN = "([0-9]{8}.[0-9]{6})-([0-9]+)";

    @Override
    public final Map<GAVCoordinate, PluginMetadata> findAvailablePlugins() {
        File[] plugins = this.getPluginFolders();
        if (null == plugins) {
            return Collections.emptyMap();
        }
        HashMap<GAVCoordinate, PluginMetadata> installedPlugins = new HashMap<GAVCoordinate, PluginMetadata>(plugins.length);
        for (File f : plugins) {
            PluginMetadata md;
            File pluginJar;
            if (!f.isDirectory() || !(pluginJar = AbstractFileNexusPluginRepository.getPluginJar(f)).isFile() || null == (md = this.getPluginMetadata(pluginJar))) continue;
            installedPlugins.put(new GAVCoordinate(md.getGroupId(), md.getArtifactId(), md.getVersion()), md);
        }
        return installedPlugins;
    }

    @Override
    public final PluginRepositoryArtifact resolveArtifact(GAVCoordinate gav) throws NoSuchPluginRepositoryArtifactException {
        return new PluginRepositoryArtifact(gav, this.resolvePluginJar(gav), this);
    }

    @Override
    public final PluginRepositoryArtifact resolveDependencyArtifact(PluginRepositoryArtifact plugin, GAVCoordinate gav) throws NoSuchPluginRepositoryArtifactException {
        File dependencyArtifact = this.resolveSnapshotOrReleaseDependencyArtifact(plugin, gav);
        if (dependencyArtifact == null || !dependencyArtifact.isFile()) {
            throw new NoSuchPluginRepositoryArtifactException(this, gav);
        }
        return new PluginRepositoryArtifact(gav, dependencyArtifact, this);
    }

    @Override
    public final PluginMetadata getPluginMetadata(GAVCoordinate gav) throws NoSuchPluginRepositoryArtifactException {
        return this.getPluginMetadata(this.resolvePluginJar(gav));
    }

    protected abstract File getNexusPluginsDirectory();

    protected File getPluginDependenciesFolder(PluginRepositoryArtifact plugin) {
        return new File(this.getPluginFolder(plugin.getCoordinate()), "dependencies");
    }

    protected File resolveSnapshotOrReleaseDependencyArtifact(PluginRepositoryArtifact plugin, GAVCoordinate gav) {
        File dependenciesFolder = this.getPluginDependenciesFolder(plugin);
        File dependencyArtifact = new File(dependenciesFolder, gav.getFinalName(this.packagingMapper));
        if (dependencyArtifact.isFile()) {
            return dependencyArtifact;
        }
        if (Gav.isSnapshot(gav.getVersion())) {
            StringBuilder buf = new StringBuilder();
            if (StringUtils.isNotEmpty((String)gav.getClassifier())) {
                buf.append('-').append(gav.getClassifier());
            }
            if (StringUtils.isNotEmpty((String)gav.getType())) {
                buf.append('.').append(this.packagingMapper.getExtensionForPackaging(gav.getType()));
            } else {
                buf.append(".jar");
            }
            String versionBaseline = gav.getVersion().substring(0, gav.getVersion().length() - "SNAPSHOT".length());
            final Pattern pattern = Pattern.compile("^" + Pattern.quote(gav.getArtifactId()) + "-" + Pattern.quote(versionBaseline) + SNAPSHOT_TIMESTAMP_FILE_PATTERN + Pattern.quote(buf.toString()) + "$");
            File[] dependencies = dependenciesFolder.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return pattern.matcher(name).matches();
                }
            });
            if (dependencies != null && dependencies.length == 1 && dependencies[0].isFile()) {
                return dependencies[0];
            }
        }
        return null;
    }

    protected File[] getPluginFolders() {
        return this.getNexusPluginsDirectory().listFiles();
    }

    protected File getPluginFolder(GAVCoordinate gav) {
        return new File(this.getNexusPluginsDirectory(), gav.getArtifactId() + '-' + gav.getVersion());
    }

    private static final File getPluginJar(File pluginFolder) {
        return new File(pluginFolder, pluginFolder.getName() + ".jar");
    }

    private final File resolvePluginJar(GAVCoordinate gav) throws NoSuchPluginRepositoryArtifactException {
        File pluginFolder = this.getPluginFolder(gav);
        File pluginJar = AbstractFileNexusPluginRepository.getPluginJar(pluginFolder);
        if (pluginJar.isFile()) {
            return pluginJar;
        }
        throw new NoSuchPluginRepositoryArtifactException(this, gav);
    }

    private final PluginMetadata getPluginMetadata(File file) {
        try {
            return this.getPluginMetadata(new URL("jar:" + file.toURI() + "!/" + PLUGIN_XML));
        }
        catch (IOException e) {
            return null;
        }
    }
}

