/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins;

import java.util.ArrayList;
import java.util.List;
import org.sonatype.nexus.plugins.PluginActivationRequest;
import org.sonatype.nexus.plugins.PluginResponse;
import org.sonatype.plugin.metadata.GAVCoordinate;

@Deprecated
public final class PluginManagerResponse {
    private static final String LS = System.getProperty("line.separator");
    private final GAVCoordinate originator;
    private final PluginActivationRequest request;
    private final List<PluginResponse> responses = new ArrayList<PluginResponse>(5);

    PluginManagerResponse(GAVCoordinate originator, PluginActivationRequest request) {
        this.originator = originator;
        this.request = request;
    }

    public GAVCoordinate getOriginator() {
        return this.originator;
    }

    public PluginActivationRequest getRequest() {
        return this.request;
    }

    public boolean isSuccessful() {
        for (PluginResponse r : this.responses) {
            if (r.isSuccessful()) continue;
            return false;
        }
        return true;
    }

    public String formatAsString(boolean detailed) {
        StringBuilder buf = new StringBuilder();
        boolean successful = this.isSuccessful();
        buf.append("Plugin manager request \"").append((Object)this.request).append("\" on plugin \"").append(this.originator);
        buf.append(successful ? "\" was successful." : "\" FAILED!");
        if (detailed || !successful) {
            buf.append(LS).append("The following plugins were processed:").append(LS);
            for (PluginResponse r : this.responses) {
                buf.append(r.formatAsString(detailed));
            }
        }
        return buf.toString();
    }

    void addPluginResponse(PluginResponse response) {
        this.responses.add(response);
    }

    void addPluginManagerResponse(PluginManagerResponse managerResponse) {
        this.responses.addAll(managerResponse.responses);
    }
}

