/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.sonatype.plugin.metadata.GAVCoordinate;
import org.sonatype.plugins.model.PluginMetadata;

@Deprecated
public final class PluginDescriptor {
    private static final String LS = System.getProperty("line.separator");
    private final GAVCoordinate gav;
    private PluginMetadata metadata;
    private List<GAVCoordinate> importedPlugins = Collections.emptyList();
    private List<GAVCoordinate> resolvedPlugins = Collections.emptyList();

    PluginDescriptor(GAVCoordinate gav) {
        this.gav = gav;
    }

    public GAVCoordinate getPluginCoordinates() {
        return this.gav;
    }

    public PluginMetadata getPluginMetadata() {
        return this.metadata;
    }

    public List<GAVCoordinate> getImportedPlugins() {
        return this.importedPlugins;
    }

    public List<GAVCoordinate> getResolvedPlugins() {
        return this.resolvedPlugins;
    }

    public String formatAsString() {
        StringBuilder buf = new StringBuilder();
        buf.append("       Detailed report about plugin \"").append(this.gav).append("\":").append(LS);
        if (this.metadata != null) {
            buf.append(LS);
            buf.append("         Source: \"").append(this.metadata.sourceUrl).append("\"").append(LS);
        }
        if (this.importedPlugins != null) {
            buf.append(LS);
            buf.append("         Imported plugins:").append(LS);
            for (GAVCoordinate gav : this.importedPlugins) {
                buf.append("         * GAV \"").append(gav.toString()).append(LS);
            }
        }
        if (this.resolvedPlugins != null) {
            buf.append(LS);
            buf.append("        Resolved plugins:").append(LS);
            for (GAVCoordinate gav : this.resolvedPlugins) {
                buf.append("         * GAV \"").append(gav.toString()).append(LS);
            }
        }
        return buf.toString();
    }

    void setPluginMetadata(PluginMetadata metadata) {
        this.metadata = metadata;
    }

    void setImportedPlugins(List<GAVCoordinate> plugins) {
        this.importedPlugins = Collections.unmodifiableList(new ArrayList<GAVCoordinate>(plugins));
    }

    void setResolvedPlugins(List<GAVCoordinate> plugins) {
        this.resolvedPlugins = Collections.unmodifiableList(new ArrayList<GAVCoordinate>(plugins));
    }
}

