/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins;

import com.google.common.base.Preconditions;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.yammer.metrics.annotation.Timed;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.eclipse.sisu.Parameters;
import org.eclipse.sisu.bean.BeanManager;
import org.eclipse.sisu.inject.DefaultRankingFunction;
import org.eclipse.sisu.inject.MutableBeanLocator;
import org.eclipse.sisu.inject.RankingFunction;
import org.eclipse.sisu.plexus.DefaultPlexusBeanLocator;
import org.eclipse.sisu.plexus.PlexusAnnotatedBeanModule;
import org.eclipse.sisu.plexus.PlexusBeanConverter;
import org.eclipse.sisu.plexus.PlexusBeanLocator;
import org.eclipse.sisu.plexus.PlexusBindingModule;
import org.eclipse.sisu.plexus.PlexusXmlBeanConverter;
import org.eclipse.sisu.plexus.PlexusXmlBeanModule;
import org.eclipse.sisu.space.BundleClassSpace;
import org.eclipse.sisu.space.ClassSpace;
import org.eclipse.sisu.space.URLClassSpace;
import org.eclipse.sisu.wire.ParameterKeys;
import org.eclipse.sisu.wire.WireModule;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.wiring.BundleWiring;
import org.sonatype.aether.util.version.GenericVersionScheme;
import org.sonatype.aether.version.InvalidVersionSpecificationException;
import org.sonatype.aether.version.Version;
import org.sonatype.aether.version.VersionScheme;
import org.sonatype.nexus.events.AbstractEvent;
import org.sonatype.nexus.guice.AbstractInterceptorModule;
import org.sonatype.nexus.guice.NexusModules;
import org.sonatype.nexus.guice.NexusTypeBinder;
import org.sonatype.nexus.plugins.NexusPluginManager;
import org.sonatype.nexus.plugins.PluginActivationRequest;
import org.sonatype.nexus.plugins.PluginActivationResult;
import org.sonatype.nexus.plugins.PluginDescriptor;
import org.sonatype.nexus.plugins.PluginManagerResponse;
import org.sonatype.nexus.plugins.PluginResponse;
import org.sonatype.nexus.plugins.events.PluginActivatedEvent;
import org.sonatype.nexus.plugins.events.PluginRejectedEvent;
import org.sonatype.nexus.plugins.repository.NexusPluginRepository;
import org.sonatype.nexus.plugins.repository.NoSuchPluginRepositoryArtifactException;
import org.sonatype.nexus.plugins.repository.PluginRepositoryArtifact;
import org.sonatype.nexus.util.AlphanumComparator;
import org.sonatype.plugin.metadata.GAVCoordinate;
import org.sonatype.plugins.model.ClasspathDependency;
import org.sonatype.plugins.model.PluginDependency;
import org.sonatype.plugins.model.PluginMetadata;
import org.sonatype.sisu.goodies.eventbus.EventBus;

@Named
@Singleton
@Deprecated
public class DefaultNexusPluginManager
implements NexusPluginManager {
    private final EventBus eventBus;
    private final NexusPluginRepository repositoryManager;
    private final Map<String, String> variables;
    private final List<AbstractInterceptorModule> interceptorModules;
    private final MutableBeanLocator beanLocator;
    private final BeanManager beanManager;
    private final Provider<Bundle> systemBundleProvider;
    private final Map<GAVCoordinate, PluginDescriptor> activePlugins = new HashMap<GAVCoordinate, PluginDescriptor>();
    private final Map<GAVCoordinate, PluginResponse> pluginResponses = new HashMap<GAVCoordinate, PluginResponse>();
    private final VersionScheme versionParser = new GenericVersionScheme();
    private final AtomicInteger pluginRank = new AtomicInteger(1);

    @Inject
    public DefaultNexusPluginManager(EventBus eventBus, NexusPluginRepository repositoryManager, @Parameters Map<String, String> variables, List<AbstractInterceptorModule> interceptorModules, MutableBeanLocator beanLocator, BeanManager beanManager, Provider<Bundle> systemBundleProvider) {
        this.eventBus = (EventBus)Preconditions.checkNotNull((Object)eventBus);
        this.repositoryManager = (NexusPluginRepository)Preconditions.checkNotNull((Object)repositoryManager);
        this.variables = (Map)Preconditions.checkNotNull(variables);
        this.interceptorModules = (List)Preconditions.checkNotNull(interceptorModules);
        this.beanLocator = (MutableBeanLocator)Preconditions.checkNotNull((Object)beanLocator);
        this.beanManager = (BeanManager)Preconditions.checkNotNull((Object)beanManager);
        this.systemBundleProvider = (Provider)Preconditions.checkNotNull(systemBundleProvider);
    }

    @Override
    public Map<GAVCoordinate, PluginResponse> getPluginResponses() {
        return new HashMap<GAVCoordinate, PluginResponse>(this.pluginResponses);
    }

    @Override
    @Timed
    public Collection<PluginManagerResponse> activateInstalledPlugins() {
        ArrayList<PluginManagerResponse> result = new ArrayList<PluginManagerResponse>();
        Map<GAVCoordinate, PluginMetadata> filteredPlugins = this.filterInstalledPlugins(this.repositoryManager.findAvailablePlugins());
        for (GAVCoordinate gav : filteredPlugins.keySet()) {
            result.add(this.activatePlugin(gav, true, filteredPlugins.keySet()));
        }
        return result;
    }

    protected Map<GAVCoordinate, PluginMetadata> filterInstalledPlugins(Map<GAVCoordinate, PluginMetadata> installedPlugins) {
        HashMap<GAVCoordinate, PluginMetadata> result = new HashMap<GAVCoordinate, PluginMetadata>(installedPlugins.size());
        block0: for (Map.Entry<GAVCoordinate, PluginMetadata> installedEntry : installedPlugins.entrySet()) {
            Iterator<Map.Entry<GAVCoordinate, PluginMetadata>> resultItr = result.entrySet().iterator();
            while (resultItr.hasNext()) {
                Map.Entry<GAVCoordinate, PluginMetadata> resultEntry = resultItr.next();
                if (!resultEntry.getKey().matchesByGA(installedEntry.getKey())) continue;
                if (this.compareVersionStrings(resultEntry.getKey().getVersion(), installedEntry.getKey().getVersion()) >= 0) continue block0;
                resultItr.remove();
            }
            result.put(installedEntry.getKey(), installedEntry.getValue());
        }
        return result;
    }

    protected int compareVersionStrings(String v1str, String v2str) {
        try {
            Version v1 = this.versionParser.parseVersion(v1str);
            Version v2 = this.versionParser.parseVersion(v2str);
            return v1.compareTo((Object)v2);
        }
        catch (InvalidVersionSpecificationException e) {
            return new AlphanumComparator().compare(v1str, v2str);
        }
    }

    protected GAVCoordinate getActivatedPluginGav(GAVCoordinate gav, boolean strict) {
        if (this.activePlugins.containsKey(gav)) {
            return gav;
        }
        if (!strict) {
            for (GAVCoordinate coord : this.activePlugins.keySet()) {
                if (!coord.matchesByGA(gav)) continue;
                return coord;
            }
        }
        return null;
    }

    protected PluginManagerResponse activatePlugin(GAVCoordinate gav, boolean strict, Set<GAVCoordinate> installedPluginsFilteredByGA) {
        GAVCoordinate activatedGav = this.getActivatedPluginGav(gav, strict);
        if (activatedGav == null) {
            GAVCoordinate actualGAV = null;
            if (!strict) {
                actualGAV = this.findInstalledPluginByGA(installedPluginsFilteredByGA, gav);
            }
            if (actualGAV == null) {
                actualGAV = gav;
            }
            PluginManagerResponse response = new PluginManagerResponse(actualGAV, PluginActivationRequest.ACTIVATE);
            try {
                this.activatePlugin(this.repositoryManager.resolveArtifact(actualGAV), response, installedPluginsFilteredByGA);
            }
            catch (NoSuchPluginRepositoryArtifactException e) {
                this.reportMissingPlugin(response, e);
            }
            return response;
        }
        return new PluginManagerResponse(activatedGav, PluginActivationRequest.ACTIVATE);
    }

    private GAVCoordinate findInstalledPluginByGA(Set<GAVCoordinate> installedPluginsFilteredByGA, GAVCoordinate gav) {
        if (installedPluginsFilteredByGA != null) {
            for (GAVCoordinate coord : installedPluginsFilteredByGA) {
                if (!coord.matchesByGA(gav)) continue;
                return coord;
            }
        }
        return null;
    }

    private void activatePlugin(PluginRepositoryArtifact plugin, PluginManagerResponse response, Set<GAVCoordinate> installedPluginsFilteredByGA) throws NoSuchPluginRepositoryArtifactException {
        GAVCoordinate pluginGAV = plugin.getCoordinate();
        PluginMetadata metadata = plugin.getPluginMetadata();
        PluginDescriptor descriptor = new PluginDescriptor(pluginGAV);
        descriptor.setPluginMetadata(metadata);
        PluginResponse result = new PluginResponse(pluginGAV, PluginActivationRequest.ACTIVATE);
        result.setPluginDescriptor(descriptor);
        this.activePlugins.put(pluginGAV, descriptor);
        ArrayList<GAVCoordinate> importList = new ArrayList<GAVCoordinate>();
        ArrayList<GAVCoordinate> resolvedList = new ArrayList<GAVCoordinate>();
        for (PluginDependency pd : metadata.getPluginDependencies()) {
            GAVCoordinate gav = new GAVCoordinate(pd.getGroupId(), pd.getArtifactId(), pd.getVersion());
            PluginManagerResponse dependencyActivationResponse = this.activatePlugin(gav, false, installedPluginsFilteredByGA);
            response.addPluginManagerResponse(dependencyActivationResponse);
            importList.add(dependencyActivationResponse.getOriginator());
            resolvedList.add(dependencyActivationResponse.getOriginator());
        }
        descriptor.setImportedPlugins(importList);
        descriptor.setResolvedPlugins(resolvedList);
        if (!response.isSuccessful()) {
            result.setAchievedGoal(PluginActivationResult.BROKEN);
        } else {
            try {
                this.createPluginInjector(plugin, descriptor);
                result.setAchievedGoal(PluginActivationResult.ACTIVATED);
            }
            catch (Throwable e) {
                result.setThrowable(e);
            }
        }
        this.reportActivationResult(response, result);
    }

    void createPluginInjector(PluginRepositoryArtifact plugin, PluginDescriptor descriptor) throws NoSuchPluginRepositoryArtifactException {
        Bundle pluginBundle;
        String location = "reference:" + plugin.getFile().getParentFile().toURI();
        try {
            pluginBundle = ((Bundle)this.systemBundleProvider.get()).getBundleContext().installBundle(location);
            pluginBundle.start();
        }
        catch (BundleException e) {
            throw new IllegalStateException("Problem installing: " + location, e);
        }
        ArrayList<URL> scanList = new ArrayList<URL>();
        URL pluginURL = DefaultNexusPluginManager.toURL(plugin);
        if (null != pluginURL) {
            scanList.add(pluginURL);
        }
        for (ClasspathDependency d : descriptor.getPluginMetadata().getClasspathDependencies()) {
            GAVCoordinate gav = new GAVCoordinate(d.getGroupId(), d.getArtifactId(), d.getVersion(), d.getClassifier(), d.getType());
            URL url = DefaultNexusPluginManager.toURL(this.repositoryManager.resolveDependencyArtifact(plugin, gav));
            if (null == url || !d.isHasComponents() && !d.isShared() && !DefaultNexusPluginManager.hasComponents(url)) continue;
            scanList.add(url);
        }
        ArrayList<Object> beanModules = new ArrayList<Object>();
        BundleClassSpace pluginSpace = new BundleClassSpace(pluginBundle);
        beanModules.add(new PlexusXmlBeanModule((ClassSpace)pluginSpace, this.variables));
        ClassLoader pluginLoader = ((BundleWiring)pluginBundle.adapt(BundleWiring.class)).getClassLoader();
        URLClassSpace scanSpace = new URLClassSpace(pluginLoader, scanList.toArray(new URL[scanList.size()]));
        beanModules.add(new PlexusAnnotatedBeanModule((ClassSpace)scanSpace, this.variables).with(NexusTypeBinder.STRATEGY));
        ArrayList<Object> modules = new ArrayList<Object>();
        modules.add((Object)new NexusModules.PluginModule());
        modules.addAll(this.interceptorModules);
        modules.add(new PlexusBindingModule(this.beanManager, beanModules));
        modules.add(new AbstractModule(){

            protected void configure() {
                this.bind(MutableBeanLocator.class).toInstance((Object)DefaultNexusPluginManager.this.beanLocator);
                this.bind(RankingFunction.class).toInstance((Object)new DefaultRankingFunction(DefaultNexusPluginManager.this.pluginRank.incrementAndGet()));
                this.bind(PlexusBeanLocator.class).to(DefaultPlexusBeanLocator.class);
                this.bind(PlexusBeanConverter.class).to(PlexusXmlBeanConverter.class);
                this.bind(ParameterKeys.PROPERTIES).toInstance((Object)DefaultNexusPluginManager.this.variables);
            }
        });
        Guice.createInjector((Module[])new Module[]{new WireModule(modules)});
    }

    private static URL toURL(PluginRepositoryArtifact artifact) {
        try {
            return artifact.getFile().toURI().toURL();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private static boolean hasComponents(URL url) {
        try {
            URL sisuIndexUrl = url.toURI().resolve("META-INF/sisu/" + Named.class.getName()).toURL();
            if (DefaultNexusPluginManager.exists(sisuIndexUrl)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean exists(URL url) {
        try (InputStream content = url.openStream();){
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    private void reportMissingPlugin(PluginManagerResponse response, NoSuchPluginRepositoryArtifactException cause) {
        GAVCoordinate gav = cause.getCoordinate();
        PluginResponse result = new PluginResponse(gav, response.getRequest());
        result.setThrowable(cause);
        result.setAchievedGoal(PluginActivationResult.MISSING);
        response.addPluginResponse(result);
        this.pluginResponses.put(gav, result);
    }

    private void reportActivationResult(PluginManagerResponse response, PluginResponse result) {
        AbstractEvent pluginEvent;
        GAVCoordinate gav = result.getPluginCoordinates();
        if (result.isSuccessful()) {
            pluginEvent = new PluginActivatedEvent(this, result.getPluginDescriptor());
        } else {
            pluginEvent = new PluginRejectedEvent(this, gav, result.getThrowable());
            this.activePlugins.remove(gav);
        }
        response.addPluginResponse(result);
        this.pluginResponses.put(gav, result);
        this.eventBus.post((Object)pluginEvent);
    }
}

