/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.notification.events;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.events.Event;
import org.sonatype.nexus.events.EventSubscriber;
import org.sonatype.nexus.notification.NotificationManager;
import org.sonatype.nexus.notification.NotificationRequest;
import org.sonatype.nexus.notification.events.NotificationEventRouter;

@Named
@Singleton
public class NotificationEventInspector
implements EventSubscriber {
    private final NotificationEventRouter notificationEventRouter;
    private final NotificationManager notificationManager;

    @Inject
    public NotificationEventInspector(NotificationEventRouter notificationEventRouter, NotificationManager notificationManager) {
        this.notificationEventRouter = (NotificationEventRouter)Preconditions.checkNotNull((Object)notificationEventRouter);
        this.notificationManager = (NotificationManager)Preconditions.checkNotNull((Object)notificationManager);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void inspect(Event<?> evt) {
        if (!this.notificationManager.isEnabled()) {
            return;
        }
        NotificationRequest route = this.notificationEventRouter.getRequestForEvent(evt);
        if (route != null && !route.isEmpty()) {
            this.notificationManager.notifyTargets(route);
        }
    }
}

