/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.notification.events;

import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.events.Event;
import org.sonatype.nexus.notification.NotificationManager;
import org.sonatype.nexus.notification.NotificationRequest;
import org.sonatype.nexus.notification.NotificationTarget;
import org.sonatype.nexus.notification.events.NotificationEventRouter;
import org.sonatype.nexus.notification.events.RepositoryEventProxyModeMessage;
import org.sonatype.nexus.proxy.events.RepositoryEventProxyModeChanged;
import org.sonatype.nexus.proxy.events.RepositoryEventProxyModeSet;
import org.sonatype.nexus.proxy.repository.ProxyMode;

@Named
@Singleton
public class DefaultNotificationEventRouter
implements NotificationEventRouter {
    private final NotificationManager notificationManager;
    private Set<String> autoBlockedRepositoryIds;

    @Inject
    public DefaultNotificationEventRouter(NotificationManager notificationManager) {
        this.notificationManager = (NotificationManager)Preconditions.checkNotNull((Object)notificationManager);
    }

    @Override
    public NotificationRequest getRequestForEvent(Event<?> evt) {
        if (evt instanceof RepositoryEventProxyModeSet) {
            NotificationTarget autoBlockTarget;
            RepositoryEventProxyModeSet rpmevt = (RepositoryEventProxyModeSet)evt;
            HashSet<NotificationTarget> targets = new HashSet<NotificationTarget>();
            if (ProxyMode.BLOCKED_AUTO.equals((Object)rpmevt.getNewProxyMode()) && rpmevt.getRepository().getCurrentRemoteStatusRetainTime() >= 120000L && !this.getAutoBlockedRepositoryIds().contains(rpmevt.getRepository().getId()) && (autoBlockTarget = this.notificationManager.readNotificationTarget("autoBlockTarget")) != null) {
                targets.add(autoBlockTarget);
                this.getAutoBlockedRepositoryIds().add(rpmevt.getRepository().getId());
            }
            if (!targets.isEmpty()) {
                RepositoryEventProxyModeMessage message = new RepositoryEventProxyModeMessage(rpmevt, null);
                return new NotificationRequest(message, targets);
            }
            return NotificationRequest.EMPTY;
        }
        if (evt instanceof RepositoryEventProxyModeChanged) {
            NotificationTarget autoBlockTarget;
            RepositoryEventProxyModeChanged rpmevt = (RepositoryEventProxyModeChanged)evt;
            HashSet<NotificationTarget> targets = new HashSet<NotificationTarget>();
            if (this.getAutoBlockedRepositoryIds().contains(rpmevt.getRepository().getId()) && (autoBlockTarget = this.notificationManager.readNotificationTarget("autoBlockTarget")) != null) {
                targets.add(autoBlockTarget);
                this.getAutoBlockedRepositoryIds().remove(rpmevt.getRepository().getId());
            }
            if (!targets.isEmpty()) {
                RepositoryEventProxyModeMessage message = new RepositoryEventProxyModeMessage(rpmevt, null);
                return new NotificationRequest(message, targets);
            }
            return NotificationRequest.EMPTY;
        }
        return NotificationRequest.EMPTY;
    }

    protected Set<String> getAutoBlockedRepositoryIds() {
        if (this.autoBlockedRepositoryIds == null) {
            this.autoBlockedRepositoryIds = new HashSet<String>();
        }
        return this.autoBlockedRepositoryIds;
    }
}

