/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.notification;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.micromailer.Address;
import org.sonatype.micromailer.MailRequest;
import org.sonatype.nexus.email.NexusEmailer;
import org.sonatype.nexus.notification.Carrier;
import org.sonatype.nexus.notification.NotificationException;
import org.sonatype.nexus.notification.NotificationMessage;
import org.sonatype.nexus.notification.NotificationTarget;
import org.sonatype.security.SecuritySystem;
import org.sonatype.security.usermanagement.User;
import org.sonatype.security.usermanagement.UserNotFoundException;
import org.sonatype.security.usermanagement.UserSearchCriteria;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Named(value="email")
@Singleton
public class EmailCarrier
extends ComponentSupport
implements Carrier {
    public static final String KEY = "email";
    private final NexusEmailer nexusEmailer;
    private final SecuritySystem securitySystem;

    @Inject
    public EmailCarrier(NexusEmailer nexusEmailer, SecuritySystem securitySystem) {
        this.nexusEmailer = (NexusEmailer)Preconditions.checkNotNull((Object)nexusEmailer);
        this.securitySystem = (SecuritySystem)Preconditions.checkNotNull((Object)securitySystem);
    }

    @Override
    public void notifyTarget(NotificationTarget target, NotificationMessage message) throws NotificationException {
        MailRequest request = this.nexusEmailer.getDefaultMailRequest(message.getMessageTitle(), message.getMessageBody());
        request.getToAddresses().addAll(this.resolveToAddresses(target));
        if (request.getToAddresses().size() > 0) {
            this.log.info("Sending out e-mail notification to notification group \"" + target.getTargetId() + "\" (total of " + request.getToAddresses().size() + " recipients).");
            this.nexusEmailer.sendMail(request);
        } else {
            this.log.info("Not sending out e-mail notification to notification group \"" + target.getTargetId() + "\", there were no recipients (does users have e-mail accessible to Realm?).");
        }
    }

    public List<Address> resolveToAddresses(NotificationTarget target) throws NotificationException {
        ArrayList<Address> toAddresses = new ArrayList<Address>();
        if (target.getTargetRoles().size() > 0) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Role ID's to notify (" + target.getTargetRoles().toString() + ")");
            }
            UserSearchCriteria criteria = new UserSearchCriteria();
            criteria.setOneOfRoleIds(target.getTargetRoles());
            Set users = this.securitySystem.searchUsers(criteria);
            if (users.size() > 0) {
                for (User user : users) {
                    if (!StringUtils.isNotBlank((String)user.getEmailAddress())) continue;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Adding user \"" + user.getName() + "\" (" + user.getEmailAddress() + ").");
                    }
                    toAddresses.add(new Address(user.getEmailAddress(), user.getName()));
                }
            }
        }
        if (target.getTargetUsers().size() > 0) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("User ID's to notify (" + target.getTargetUsers().toString() + ").");
            }
            for (String userId : target.getTargetUsers()) {
                if (!StringUtils.isNotBlank((String)userId)) continue;
                try {
                    User user = this.securitySystem.getUser(userId);
                    if (!StringUtils.isNotBlank((String)user.getEmailAddress())) continue;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Adding user \"" + user.getName() + "\" (" + user.getEmailAddress() + ").");
                    }
                    toAddresses.add(new Address(user.getEmailAddress(), user.getName()));
                }
                catch (UserNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
        if (target.getExternalTargets().size() > 0) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("External emails to notify (" + target.getExternalTargets().toString() + ").");
            }
            for (String email : target.getExternalTargets()) {
                if (!StringUtils.isNotBlank((String)email)) continue;
                toAddresses.add(new Address(email));
            }
        }
        return toAddresses;
    }
}

