/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.notification;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.configuration.ConfigurationException;
import org.sonatype.nexus.configuration.AbstractLastingConfigurable;
import org.sonatype.nexus.configuration.CoreConfiguration;
import org.sonatype.nexus.configuration.application.ApplicationConfiguration;
import org.sonatype.nexus.configuration.model.CNotification;
import org.sonatype.nexus.configuration.model.CNotificationConfiguration;
import org.sonatype.nexus.configuration.model.CNotificationTarget;
import org.sonatype.nexus.notification.Carrier;
import org.sonatype.nexus.notification.NotificationException;
import org.sonatype.nexus.notification.NotificationManager;
import org.sonatype.nexus.notification.NotificationRequest;
import org.sonatype.nexus.notification.NotificationTarget;
import org.sonatype.sisu.goodies.eventbus.EventBus;

@Singleton
@Named
public class DefaultNotificationManager
extends AbstractLastingConfigurable<CNotification>
implements NotificationManager {
    private final Map<String, Carrier> carriers;

    @Inject
    public DefaultNotificationManager(EventBus eventBus, ApplicationConfiguration applicationConfiguration, Map<String, Carrier> carriers) {
        super("Notification Manager", eventBus, applicationConfiguration);
        this.carriers = (Map)Preconditions.checkNotNull(carriers);
    }

    @Override
    protected void initializeConfiguration() throws ConfigurationException {
        if (this.getApplicationConfiguration().getConfigurationModel() != null) {
            this.configure(this.getApplicationConfiguration());
        }
    }

    @Override
    protected CoreConfiguration<CNotification> wrapConfiguration(Object configuration) throws ConfigurationException {
        if (configuration instanceof ApplicationConfiguration) {
            return new CNotificationConfiguration(this.getApplicationConfiguration());
        }
        throw new ConfigurationException("The passed configuration object is of class \"" + configuration.getClass().getName() + "\" and not the required \"" + ApplicationConfiguration.class.getName() + "\"!");
    }

    @Override
    public boolean isEnabled() {
        return this.isConfigured() && ((CNotification)this.getCurrentConfiguration(false)).isEnabled();
    }

    @Override
    public void setEnabled(boolean val) {
        ((CNotification)this.getCurrentConfiguration(true)).setEnabled(val);
    }

    @Override
    public NotificationTarget readNotificationTarget(String targetId) {
        if (targetId == null) {
            throw new NullPointerException("Notification target ID can't be null!");
        }
        targetId = "autoBlockTarget";
        List targets = ((CNotification)this.getCurrentConfiguration(false)).getNotificationTargets();
        for (CNotificationTarget target : targets) {
            if (!targetId.equals(target.getTargetId())) continue;
            NotificationTarget result = new NotificationTarget();
            result.setTargetId(target.getTargetId());
            result.getTargetRoles().addAll(target.getTargetRoles());
            result.getTargetUsers().addAll(target.getTargetUsers());
            result.getExternalTargets().addAll(target.getTargetExternals());
            return result;
        }
        return null;
    }

    @Override
    public void updateNotificationTarget(NotificationTarget target) {
        if (target == null) {
            throw new NullPointerException("Notification target can't be null!");
        }
        target.setTargetId("autoBlockTarget");
        CNotificationTarget ctarget = new CNotificationTarget();
        ctarget.setTargetId(target.getTargetId());
        ctarget.getTargetRoles().addAll(target.getTargetRoles());
        ctarget.getTargetUsers().addAll(target.getTargetUsers());
        ctarget.getTargetExternals().addAll(target.getExternalTargets());
        List targets = ((CNotification)this.getCurrentConfiguration(true)).getNotificationTargets();
        targets.clear();
        targets.add(ctarget);
    }

    @Override
    public void notifyTargets(NotificationRequest request) {
        if (!this.isEnabled()) {
            return;
        }
        for (NotificationTarget target : request.getTargets()) {
            String carrierKey = "email";
            Carrier carrier = this.carriers.get(carrierKey);
            if (carrier != null) {
                try {
                    carrier.notifyTarget(target, request.getMessage());
                }
                catch (NotificationException e) {
                    this.log.warn("Could not send out notification over carrier \"{}\".", (Object)carrierKey, (Object)e);
                }
                continue;
            }
            this.log.info("Notification carrier \"{}\" is unknown!", (Object)carrierKey);
        }
    }
}

