/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.mime;

import com.google.common.base.Preconditions;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.sonatype.nexus.mime.MimeRulesSource;

public class RegexpMimeRulesSource
implements MimeRulesSource {
    private final LinkedHashMap<Pattern, String> rules = new LinkedHashMap();

    public void addRule(String regexpString, String mimeType) {
        this.addRule(Pattern.compile(regexpString), mimeType);
    }

    public void addRule(Pattern pattern, String mimeType) {
        this.rules.put((Pattern)Preconditions.checkNotNull((Object)pattern), (String)Preconditions.checkNotNull((Object)mimeType));
    }

    @Override
    public String getRuleForPath(String path) {
        for (Map.Entry<Pattern, String> entry : this.rules.entrySet()) {
            if (!entry.getKey().matcher(path).matches()) continue;
            return entry.getValue();
        }
        return null;
    }
}

