/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.mime;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NexusMimeTypes {
    private static Logger log = LoggerFactory.getLogger(NexusMimeTypes.class);
    public static final String BUILTIN_MIMETYPES_FILENAME = "builtin-mimetypes.properties";
    public static final String MIMETYPES_FILENAME = "nexus.mimetypes";
    private Map<String, NexusMimeType> extensions = Maps.newHashMap();

    public NexusMimeTypes() {
        this.load(BUILTIN_MIMETYPES_FILENAME);
        this.load(MIMETYPES_FILENAME);
    }

    private void load(String filename) {
        InputStream stream = this.getClass().getResourceAsStream("/" + filename);
        if (stream != null) {
            Properties properties = new Properties();
            try {
                properties.load(stream);
                this.initMimeTypes(properties);
            }
            catch (IOException e) {
                if (log.isDebugEnabled()) {
                    log.warn("Could not load nexus.mimetypes", (Throwable)e);
                }
                log.warn("Could not load nexus.mimetypes: {}", (Object)e.getMessage());
            }
        }
    }

    @VisibleForTesting
    void initMimeTypes(Properties properties) {
        List mimetypes;
        Set<String> keys = properties.stringPropertyNames();
        HashMap overrides = Maps.newHashMap();
        HashMap additional = Maps.newHashMap();
        for (String key : keys) {
            if (key.startsWith("override.")) {
                overrides.put(key.substring("override.".length()), this.types(properties.getProperty(key, null)));
                continue;
            }
            additional.put(key, this.types(properties.getProperty(key, null)));
        }
        for (String extension : overrides.keySet()) {
            mimetypes = (List)overrides.get(extension);
            if (additional.containsKey(extension)) {
                mimetypes.addAll((Collection)additional.get(extension));
                additional.remove(extension);
            }
            this.extensions.put(extension, new NexusMimeType(true, extension, mimetypes));
        }
        for (String extension : additional.keySet()) {
            mimetypes = (List)additional.get(extension);
            this.extensions.put(extension, new NexusMimeType(false, extension, mimetypes));
        }
    }

    private List<String> types(String value) {
        if (value == null) {
            return Collections.emptyList();
        }
        return Lists.newArrayList((Iterable)Splitter.on((String)",").split((CharSequence)value));
    }

    public NexusMimeType getMimeTypes(String extension) {
        while (!extension.isEmpty()) {
            if (this.extensions.containsKey(extension)) {
                return this.extensions.get(extension);
            }
            extension = FilenameUtils.getExtension((String)extension);
        }
        return null;
    }

    public class NexusMimeType {
        private boolean override;
        private String extension;
        private List<String> mimetypes;

        private NexusMimeType(boolean override, String extension, List<String> mimetypes) {
            this.override = override;
            this.extension = extension;
            this.mimetypes = mimetypes;
        }

        public String getExtension() {
            return this.extension;
        }

        public List<String> getMimetypes() {
            return this.mimetypes;
        }

        public boolean isOverride() {
            return this.override;
        }
    }
}

