/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.mime;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.io.FilenameUtils;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.detect.Detector;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.sonatype.nexus.mime.MimeRulesSource;
import org.sonatype.nexus.mime.MimeSupport;
import org.sonatype.nexus.mime.NexusMimeTypes;
import org.sonatype.nexus.proxy.item.ContentLocator;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Named
@Singleton
public class DefaultMimeSupport
extends ComponentSupport
implements MimeSupport {
    private final TikaConfig tikaConfig = TikaConfig.getDefaultConfig();
    private final Detector detector = this.tikaConfig.getDetector();
    private final LoadingCache<String, List<String>> extensionToMimeTypeCache;

    @Inject
    public DefaultMimeSupport() {
        this(new NexusMimeTypes());
    }

    @VisibleForTesting
    public DefaultMimeSupport(final NexusMimeTypes nexusMimeTypes) {
        this.extensionToMimeTypeCache = CacheBuilder.newBuilder().maximumSize(500L).build((CacheLoader)new CacheLoader<String, List<String>>(){

            public List<String> load(String key) throws Exception {
                ArrayList detected = Lists.newArrayList();
                NexusMimeTypes.NexusMimeType mimeType = nexusMimeTypes.getMimeTypes(key);
                if (mimeType != null) {
                    detected.addAll(mimeType.getMimetypes());
                    if (mimeType.isOverride()) {
                        return detected;
                    }
                }
                Metadata metadata = new Metadata();
                metadata.set("resourceName", "dummy." + key);
                MediaType mediaType = DefaultMimeSupport.this.detector.detect(null, metadata);
                while (mediaType != null) {
                    detected.add(mediaType.getBaseType().toString());
                    mediaType = DefaultMimeSupport.this.tikaConfig.getMediaTypeRegistry().getSupertype(mediaType);
                }
                return detected;
            }
        });
    }

    @Override
    public String guessMimeTypeFromPath(MimeRulesSource mimeRulesSource, String path) {
        String hardRule;
        if (mimeRulesSource != null && !Strings.isNullOrEmpty((String)(hardRule = mimeRulesSource.getRuleForPath(path)))) {
            return hardRule;
        }
        return this.guessMimeTypeFromPath(path);
    }

    @Override
    public String guessMimeTypeFromPath(String path) {
        List<String> mimeTypes = this.guessMimeTypesListFromPath(path);
        if (mimeTypes.isEmpty()) {
            return "application/octet-stream";
        }
        return mimeTypes.get(0);
    }

    @Override
    public List<String> guessMimeTypesListFromPath(String path) {
        String pathExtension = FilenameUtils.getExtension((String)path);
        try {
            return (List)this.extensionToMimeTypeCache.get((Object)pathExtension);
        }
        catch (ExecutionException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public String detectMimeTypesFromContent(StorageFileItem fileItem) throws IOException {
        List<String> mimeTypes = this.detectMimeTypesListFromContent(fileItem);
        if (mimeTypes.isEmpty()) {
            return "application/octet-stream";
        }
        return mimeTypes.get(0);
    }

    @Override
    public List<String> detectMimeTypesListFromContent(ContentLocator content) throws IOException {
        MediaType mediaType;
        ArrayList detected = Lists.newArrayList();
        try (TikaInputStream tis = TikaInputStream.get((InputStream)content.getContent());){
            mediaType = this.detector.detect((InputStream)tis, new Metadata());
        }
        while (mediaType != null) {
            detected.add(mediaType.getBaseType().toString());
            MediaType mediaType2 = this.tikaConfig.getMediaTypeRegistry().getSupertype(mediaType);
        }
        return detected;
    }

    @Override
    public List<String> detectMimeTypesListFromContent(StorageFileItem fileItem) throws IOException {
        MediaType mediaType;
        ArrayList detected = Lists.newArrayList();
        Metadata metadata = new Metadata();
        metadata.set("resourceName", fileItem.getName());
        try (TikaInputStream tis = TikaInputStream.get((InputStream)fileItem.getInputStream());){
            mediaType = this.detector.detect((InputStream)tis, metadata);
        }
        while (mediaType != null) {
            detected.add(mediaType.getBaseType().toString());
            mediaType = this.tikaConfig.getMediaTypeRegistry().getSupertype(mediaType);
        }
        return detected;
    }
}

