/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.maven.tasks.descriptors;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.formfields.CheckboxFormField;
import org.sonatype.nexus.formfields.FormField;
import org.sonatype.nexus.formfields.NumberTextFormField;
import org.sonatype.nexus.formfields.RepoOrGroupComboFormField;
import org.sonatype.nexus.tasks.descriptors.AbstractScheduledTaskDescriptor;

@Named(value="SnapshotRemoval")
@Singleton
public class SnapshotRemovalTaskDescriptor
extends AbstractScheduledTaskDescriptor {
    public static final String ID = "SnapshotRemoverTask";
    public static final String REPO_OR_GROUP_FIELD_ID = "repositoryId";
    public static final String MIN_TO_KEEP_FIELD_ID = "minSnapshotsToKeep";
    public static final String KEEP_DAYS_FIELD_ID = "removeOlderThanDays";
    public static final String REMOVE_WHEN_RELEASED_FIELD_ID = "removeIfReleaseExists";
    public static final String GRACE_DAYS_AFTER_RELEASE_FIELD_ID = "graceDaysAfterRelease";
    public static final String DELETE_IMMEDIATELY = "deleteImmediately";
    private final RepoOrGroupComboFormField repoField = new RepoOrGroupComboFormField("repositoryId", true);
    private final NumberTextFormField minToKeepField = new NumberTextFormField("minSnapshotsToKeep", "Minimum snapshot count", "Minimum number of snapshots to keep for one GAV.", true);
    private final NumberTextFormField keepDaysField = new NumberTextFormField("removeOlderThanDays", "Snapshot retention (days)", "The job will purge all snapshots older than the entered number of days, but will obey to Min. count of snapshots to keep.", true);
    private final CheckboxFormField removeWhenReleasedField = new CheckboxFormField("removeIfReleaseExists", "Remove if released", "The job will purge all snapshots that have a corresponding released artifact (same version not including the -SNAPSHOT).", false);
    private final NumberTextFormField graceDaysAfterReleaseField = new NumberTextFormField("graceDaysAfterRelease", "Grace period after release (days)", "The grace period (in days) that the task will not purge all snapshots that have a corresponding released artifact.", false);
    private final CheckboxFormField deleteImmediatelyField = new CheckboxFormField("deleteImmediately", "Delete immediately", "The job will not move deleted items into the repository trash but delete immediately.", false);

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getName() {
        return "Remove Snapshots From Repository";
    }

    @Override
    public List<FormField> formFields() {
        ArrayList<FormField> fields = new ArrayList<FormField>();
        fields.add(this.repoField);
        fields.add(this.minToKeepField);
        fields.add(this.keepDaysField);
        fields.add(this.removeWhenReleasedField);
        fields.add(this.graceDaysAfterReleaseField);
        fields.add(this.deleteImmediatelyField);
        return fields;
    }
}

