/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.maven.tasks;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.aether.util.version.GenericVersionScheme;
import org.sonatype.aether.version.InvalidVersionSpecificationException;
import org.sonatype.aether.version.Version;
import org.sonatype.aether.version.VersionScheme;
import org.sonatype.nexus.maven.tasks.AbstractFileDeletingWalkerProcessor;
import org.sonatype.nexus.maven.tasks.ReleaseRemovalRequest;
import org.sonatype.nexus.maven.tasks.ReleaseRemovalResult;
import org.sonatype.nexus.maven.tasks.ReleaseRemoverBackend;
import org.sonatype.nexus.proxy.IllegalOperationException;
import org.sonatype.nexus.proxy.ItemNotFoundException;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.StorageException;
import org.sonatype.nexus.proxy.item.StorageCollectionItem;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.maven.MavenRepository;
import org.sonatype.nexus.proxy.maven.gav.Gav;
import org.sonatype.nexus.proxy.targets.Target;
import org.sonatype.nexus.proxy.targets.TargetStoreWalkerFilter;
import org.sonatype.nexus.proxy.walker.ConjunctionWalkerFilter;
import org.sonatype.nexus.proxy.walker.DefaultWalkerContext;
import org.sonatype.nexus.proxy.walker.DottedStoreWalkerFilter;
import org.sonatype.nexus.proxy.walker.Walker;
import org.sonatype.nexus.proxy.walker.WalkerContext;
import org.sonatype.nexus.proxy.walker.WalkerFilter;
import org.sonatype.nexus.proxy.wastebasket.DeleteOperation;
import org.sonatype.scheduling.TaskUtil;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Named(value="walker")
@Singleton
public class WalkerReleaseRemoverBackend
extends ComponentSupport
implements ReleaseRemoverBackend {
    private final Walker walker;
    private final VersionScheme versionScheme;

    @Inject
    public WalkerReleaseRemoverBackend(Walker walker) {
        this.walker = (Walker)Preconditions.checkNotNull((Object)walker);
        this.versionScheme = new GenericVersionScheme();
    }

    @Override
    public void removeReleases(ReleaseRemovalRequest request, ReleaseRemovalResult result, MavenRepository repository, @Nullable Target repositoryTarget) throws IOException {
        TaskUtil.checkInterruption();
        this.log.debug("Collecting deletable releases on repository '{}' from storage directory {}", (Object)repository.getId(), (Object)repository.getLocalUrl());
        DefaultWalkerContext ctxMain = new DefaultWalkerContext(repository, new ResourceStoreRequest("/"), this.determineFilter(repositoryTarget));
        ctxMain.getContext().put(DeleteOperation.DELETE_OPERATION_CTX_KEY, (Object)DeleteOperation.MOVE_TO_TRASH);
        ctxMain.getProcessors().add(new ReleaseRemovalWalkerProcessor(repository, request, result, repositoryTarget));
        this.walker.walk(ctxMain);
        if (ctxMain.getStopCause() != null) {
            result.setSuccessful(false);
        }
    }

    private WalkerFilter determineFilter(Target repositoryTarget) {
        if (repositoryTarget == null) {
            return new DottedStoreWalkerFilter();
        }
        return ConjunctionWalkerFilter.satisfiesAllOf(new DottedStoreWalkerFilter(), new TargetStoreWalkerFilter(repositoryTarget));
    }

    private class ReleaseRemovalWalkerProcessor
    extends AbstractFileDeletingWalkerProcessor {
        private static final String POSSIBLY_EMPTY_COLLECTIONS = "possiblyEmptyCollections";
        private final MavenRepository repository;
        private final ReleaseRemovalRequest request;
        private final Map<Version, List<StorageFileItem>> deletableVersionsAndFiles = Maps.newHashMap();
        private final Map<Gav, Map<Version, List<StorageFileItem>>> groupArtifactToVersions = Maps.newHashMap();
        private final ReleaseRemovalResult result;
        private final Target repositoryTarget;
        private int deletedFiles = 0;

        private ReleaseRemovalWalkerProcessor(MavenRepository repository, ReleaseRemovalRequest request, ReleaseRemovalResult result, Target repositoryTarget) {
            this.repository = repository;
            this.request = request;
            this.result = result;
            this.repositoryTarget = repositoryTarget;
        }

        @Override
        public void processItem(WalkerContext context, StorageItem item) throws Exception {
        }

        @Override
        public void onCollectionExit(WalkerContext context, StorageCollectionItem coll) throws Exception {
            try {
                this.doOnCollectionExit(context, coll);
            }
            catch (Exception e) {
                WalkerReleaseRemoverBackend.this.log.warn("{} failed to process path: '{}'.", new Object[]{"ReleaseRemoverTask", coll.getPath(), e});
            }
        }

        private void doOnCollectionExit(WalkerContext context, StorageCollectionItem coll) throws ItemNotFoundException, StorageException, IllegalOperationException, InvalidVersionSpecificationException {
            this.deletableVersionsAndFiles.clear();
            Collection<StorageItem> items = this.repository.list(false, coll);
            Gav gav = null;
            for (StorageItem item : items) {
                if (item.isVirtual() || StorageCollectionItem.class.isAssignableFrom(item.getClass()) || (gav = ((MavenRepository)coll.getRepositoryItemUid().getRepository()).getGavCalculator().pathToGav(item.getPath())) == null) continue;
                this.addCollectionToContext(context, coll);
                this.maybeAddStorageFileItemToMap(gav, (StorageFileItem)item);
            }
            if (null != gav) {
                this.groupVersions(this.groupArtifactToVersions, this.deletableVersionsAndFiles, gav);
            }
        }

        private void maybeAddStorageFileItemToMap(Gav gav, StorageFileItem item) {
            if (this.repositoryTarget != null && !this.repositoryTarget.isPathContained(item.getRepositoryItemUid().getRepository().getRepositoryContentClass(), item.getPath())) {
                WalkerReleaseRemoverBackend.this.log.debug("Excluding file: {} from deletion due to repositoryTarget: {}.", (Object)item.getName(), (Object)this.repositoryTarget.getName());
                return;
            }
            this.addStorageFileItemToMap(this.deletableVersionsAndFiles, gav, item);
        }

        private void addCollectionToContext(WalkerContext context, StorageCollectionItem coll) {
            if (!context.getContext().containsKey(POSSIBLY_EMPTY_COLLECTIONS)) {
                context.getContext().put(POSSIBLY_EMPTY_COLLECTIONS, Lists.newArrayList());
            }
            ((List)context.getContext().get(POSSIBLY_EMPTY_COLLECTIONS)).add(coll);
        }

        private void groupVersions(Map<Gav, Map<Version, List<StorageFileItem>>> groupArtifactToVersions, Map<Version, List<StorageFileItem>> versionsAndFiles, Gav gav) {
            Gav ga = new Gav(gav.getGroupId(), gav.getArtifactId(), "");
            if (!groupArtifactToVersions.containsKey(ga)) {
                groupArtifactToVersions.put(ga, Maps.newHashMap(versionsAndFiles));
            }
            groupArtifactToVersions.get(ga).putAll(versionsAndFiles);
        }

        protected void addStorageFileItemToMap(Map<Version, List<StorageFileItem>> map, Gav gav, StorageFileItem item) {
            Version key = null;
            try {
                key = WalkerReleaseRemoverBackend.this.versionScheme.parseVersion(gav.getVersion());
            }
            catch (InvalidVersionSpecificationException e) {
                throw new IllegalStateException("Unable to determine version for " + gav.getVersion() + ", cannot proceed with deletion of releases unless" + "all version information can be parsed into major.minor.incremental version.");
            }
            if (!map.containsKey(key)) {
                map.put(key, new ArrayList());
            }
            map.get(key).add(item);
        }

        @Override
        public void afterWalk(WalkerContext context) throws Exception {
            for (Map.Entry<Gav, Map<Version, List<StorageFileItem>>> gavListEntry : this.groupArtifactToVersions.entrySet()) {
                Map<Version, List<StorageFileItem>> versions = gavListEntry.getValue();
                if (versions.size() <= this.request.getNumberOfVersionsToKeep()) continue;
                WalkerReleaseRemoverBackend.this.log.debug("{} will delete {} versions of artifact with g={} a={}", new Object[]{"ReleaseRemoverTask", versions.size() - this.request.getNumberOfVersionsToKeep(), gavListEntry.getKey().getGroupId(), gavListEntry.getKey().getArtifactId()});
                ArrayList sortedVersions = Lists.newArrayList(versions.keySet());
                Collections.sort(sortedVersions);
                List toDelete = sortedVersions.subList(0, versions.size() - this.request.getNumberOfVersionsToKeep());
                WalkerReleaseRemoverBackend.this.log.debug("Will delete these specific versions: {}", toDelete);
                for (Version version : toDelete) {
                    for (StorageFileItem storageFileItem : versions.get(version)) {
                        this.repository.deleteItem(this.createResourceStoreRequest(storageFileItem, context));
                        ++this.deletedFiles;
                    }
                }
                if (!context.getContext().containsKey(POSSIBLY_EMPTY_COLLECTIONS)) continue;
                for (StorageCollectionItem coll : (List)context.getContext().get(POSSIBLY_EMPTY_COLLECTIONS)) {
                    this.removeDirectoryIfEmpty(this.repository, coll);
                }
            }
            this.result.setDeletedFileCount(this.deletedFiles);
            this.result.setSuccessful(true);
        }
    }
}

