/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.maven.tasks;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.maven.tasks.SnapshotRemovalRequest;
import org.sonatype.nexus.maven.tasks.SnapshotRemovalResult;
import org.sonatype.nexus.maven.tasks.SnapshotRemover;
import org.sonatype.nexus.scheduling.AbstractNexusRepositoriesTask;

@Named(value="UnusedSnapshotRemoverTask")
public class UnusedSnapshotRemoverTask
extends AbstractNexusRepositoriesTask<SnapshotRemovalResult> {
    public static final String SYSTEM_REMOVE_SNAPSHOTS_ACTION = "REMOVESNAPSHOTS";
    private final SnapshotRemover snapshotRemover;

    @Inject
    public UnusedSnapshotRemoverTask(SnapshotRemover snapshotRemover) {
        this.snapshotRemover = (SnapshotRemover)Preconditions.checkNotNull((Object)snapshotRemover);
    }

    @Override
    protected String getRepositoryFieldId() {
        return "repositoryId";
    }

    public int getDaysSinceLastRequested() {
        String param = (String)this.getParameters().get("daysSinceLastRequested");
        return Integer.parseInt((String)Preconditions.checkNotNull((Object)param, (Object)"daysSinceLastRequested"));
    }

    @Override
    public SnapshotRemovalResult doRun() throws Exception {
        SnapshotRemovalRequest req = new SnapshotRemovalRequest(this.getRepositoryId(), -1, this.getDaysSinceLastRequested(), false, -1, false, true);
        return this.snapshotRemover.removeSnapshots(req);
    }

    @Override
    protected String getAction() {
        return SYSTEM_REMOVE_SNAPSHOTS_ACTION;
    }

    @Override
    protected String getMessage() {
        if (this.getRepositoryId() != null) {
            return "Removing unused snapshots from repository " + this.getRepositoryName();
        }
        return "Removing unused snapshots from all registered repositories";
    }
}

