/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.maven.tasks;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.nexus.maven.tasks.SnapshotRemovalRequest;
import org.sonatype.nexus.maven.tasks.SnapshotRemovalResult;
import org.sonatype.nexus.maven.tasks.SnapshotRemover;
import org.sonatype.nexus.scheduling.AbstractNexusRepositoriesTask;

@Named(value="SnapshotRemoverTask")
public class SnapshotRemoverTask
extends AbstractNexusRepositoriesTask<SnapshotRemovalResult> {
    public static final String SYSTEM_REMOVE_SNAPSHOTS_ACTION = "REMOVESNAPSHOTS";
    public static final int DEFAULT_MIN_SNAPSHOTS_TO_KEEP = 0;
    public static final int DEFAULT_OLDER_THAN_DAYS = -1;
    public static final int DEFAULT_GRACE_DAYS_AFTER_RELEASE = 0;
    private final SnapshotRemover snapshotRemover;

    @Inject
    public SnapshotRemoverTask(SnapshotRemover snapshotRemover) {
        this.snapshotRemover = (SnapshotRemover)Preconditions.checkNotNull((Object)snapshotRemover);
    }

    @Override
    protected String getRepositoryFieldId() {
        return "repositoryId";
    }

    public int getMinSnapshotsToKeep() {
        String param = (String)this.getParameters().get("minSnapshotsToKeep");
        if (StringUtils.isEmpty((String)param)) {
            return 0;
        }
        return Integer.parseInt(param);
    }

    public int getRemoveOlderThanDays() {
        String param = (String)this.getParameters().get("removeOlderThanDays");
        if (StringUtils.isEmpty((String)param)) {
            return -1;
        }
        return Integer.parseInt(param);
    }

    public boolean isRemoveIfReleaseExists() {
        return Boolean.parseBoolean((String)this.getParameters().get("removeIfReleaseExists"));
    }

    public int getGraceDaysAfterRelease() {
        String param = (String)this.getParameters().get("graceDaysAfterRelease");
        if (StringUtils.isEmpty((String)param)) {
            return 0;
        }
        return Integer.parseInt(param);
    }

    public boolean isDeleteImmediately() {
        return Boolean.parseBoolean((String)this.getParameters().get("deleteImmediately"));
    }

    @Override
    public SnapshotRemovalResult doRun() throws Exception {
        SnapshotRemovalRequest req = new SnapshotRemovalRequest(this.getRepositoryId(), this.getMinSnapshotsToKeep(), this.getRemoveOlderThanDays(), this.isRemoveIfReleaseExists(), this.getGraceDaysAfterRelease(), this.isDeleteImmediately());
        return this.snapshotRemover.removeSnapshots(req);
    }

    @Override
    protected String getAction() {
        return SYSTEM_REMOVE_SNAPSHOTS_ACTION;
    }

    @Override
    protected String getMessage() {
        if (this.getRepositoryId() != null) {
            return "Removing snapshots from repository " + this.getRepositoryName();
        }
        return "Removing snapshots from all registered repositories";
    }
}

