/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.maven.tasks;

import java.util.HashMap;
import java.util.Map;
import org.sonatype.nexus.maven.tasks.SnapshotRemovalRepositoryResult;

public class SnapshotRemovalResult {
    private Map<String, SnapshotRemovalRepositoryResult> processedRepositories = new HashMap<String, SnapshotRemovalRepositoryResult>();
    private boolean isSuccessful = true;

    public Map<String, SnapshotRemovalRepositoryResult> getProcessedRepositories() {
        return this.processedRepositories;
    }

    public void addResult(SnapshotRemovalRepositoryResult res) {
        if (res != null) {
            if (this.processedRepositories.containsKey(res.getRepositoryId())) {
                SnapshotRemovalRepositoryResult ex = this.processedRepositories.get(res.getRepositoryId());
                ex.setDeletedFiles(ex.getDeletedFiles() + res.getDeletedFiles());
                ex.setDeletedSnapshots(ex.getDeletedSnapshots() + res.getDeletedSnapshots());
                if (res.isSkipped()) {
                    ex.setSkippedCount(ex.getSkippedCount() + 1);
                }
            } else {
                this.processedRepositories.put(res.getRepositoryId(), res);
            }
            if (!res.isSuccessful()) {
                this.isSuccessful = false;
            }
        }
    }

    public boolean isSuccessful() {
        return this.isSuccessful;
    }
}

