/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.maven.tasks;

import java.util.HashSet;
import java.util.Set;

public class SnapshotRemovalRequest {
    private final String repositoryId;
    private final int minCountOfSnapshotsToKeep;
    private final int removeSnapshotsOlderThanDays;
    private final boolean removeIfReleaseExists;
    private final int graceDaysAfterRelease;
    private final Set<String> processedRepos;
    private final boolean deleteImmediately;
    private final boolean useLastRequestedTimestamp;

    public SnapshotRemovalRequest(String repositoryId, int minCountOfSnapshotsToKeep, int removeSnapshotsOlderThanDays, boolean removeIfReleaseExists) {
        this(repositoryId, minCountOfSnapshotsToKeep, removeSnapshotsOlderThanDays, removeIfReleaseExists, 0, false, false);
    }

    public SnapshotRemovalRequest(String repositoryId, int minCountOfSnapshotsToKeep, int removeSnapshotsOlderThanDays, boolean removeIfReleaseExists, int graceDaysAfterRelease, boolean deleteImmediately) {
        this(repositoryId, minCountOfSnapshotsToKeep, removeSnapshotsOlderThanDays, removeIfReleaseExists, graceDaysAfterRelease, deleteImmediately, false);
    }

    public SnapshotRemovalRequest(String repositoryId, int minCountOfSnapshotsToKeep, int removeSnapshotsOlderThanDays, boolean removeIfReleaseExists, int graceDaysAfterRelease, boolean deleteImmediately, boolean useLastRequestedTimestamp) {
        this.repositoryId = repositoryId;
        this.minCountOfSnapshotsToKeep = minCountOfSnapshotsToKeep;
        this.removeSnapshotsOlderThanDays = removeSnapshotsOlderThanDays;
        this.removeIfReleaseExists = removeIfReleaseExists;
        this.graceDaysAfterRelease = graceDaysAfterRelease;
        this.processedRepos = new HashSet<String>();
        this.deleteImmediately = deleteImmediately;
        this.useLastRequestedTimestamp = useLastRequestedTimestamp;
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public int getMinCountOfSnapshotsToKeep() {
        return this.minCountOfSnapshotsToKeep;
    }

    public int getRemoveSnapshotsOlderThanDays() {
        return this.removeSnapshotsOlderThanDays;
    }

    public boolean isRemoveIfReleaseExists() {
        return this.removeIfReleaseExists;
    }

    public int getGraceDaysAfterRelease() {
        return this.graceDaysAfterRelease;
    }

    public void addProcessedRepo(String repoId) {
        this.processedRepos.add(repoId);
    }

    public boolean isProcessedRepo(String repoId) {
        return this.processedRepos.contains(repoId);
    }

    public boolean isDeleteImmediately() {
        return this.deleteImmediately;
    }

    public boolean shouldUseLastRequestedTimestamp() {
        return this.useLastRequestedTimestamp;
    }
}

