/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.maven.tasks;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.maven.tasks.ReleaseRemovalRequest;
import org.sonatype.nexus.maven.tasks.ReleaseRemovalResult;
import org.sonatype.nexus.maven.tasks.ReleaseRemover;
import org.sonatype.nexus.scheduling.AbstractNexusRepositoriesTask;

@Named(value="ReleaseRemoverTask")
public class ReleaseRemoverTask
extends AbstractNexusRepositoriesTask<ReleaseRemovalResult> {
    private final ReleaseRemover releaseRemover;

    @Inject
    public ReleaseRemoverTask(ReleaseRemover releaseRemover) {
        this.releaseRemover = (ReleaseRemover)Preconditions.checkNotNull((Object)releaseRemover);
    }

    @Override
    protected String getRepositoryFieldId() {
        return "repositoryId";
    }

    @Override
    protected ReleaseRemovalResult doRun() throws Exception {
        int numberOfVersionsToKeep = Integer.parseInt(this.getParameter("numberOfVersionsToKeep"));
        String targetId = this.getParameter("repositoryTarget");
        boolean indexBackend = Boolean.valueOf(this.getParameter("indexBackend"));
        return this.releaseRemover.removeReleases(new ReleaseRemovalRequest(this.getRepositoryId(), numberOfVersionsToKeep, indexBackend, targetId));
    }

    @Override
    protected String getAction() {
        return this.getClass().getSimpleName();
    }

    @Override
    protected String getMessage() {
        return "Removing old releases from repository " + this.getRepositoryName();
    }
}

