/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.maven.tasks;

import java.util.List;
import javax.inject.Named;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.maven.MavenRepository;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.utils.RepositoryStringUtils;
import org.sonatype.nexus.scheduling.AbstractNexusRepositoriesPathAwareTask;
import org.sonatype.scheduling.TaskUtil;

@Named(value="RebuildMavenMetadataTask")
public class RebuildMavenMetadataTask
extends AbstractNexusRepositoriesPathAwareTask<Object> {
    public static final String REBUILD_MAVEN_METADATA_ACTION = "REBUILD_MAVEN_METADATA";

    @Override
    protected String getRepositoryFieldId() {
        return "repositoryId";
    }

    @Override
    protected String getRepositoryPathFieldId() {
        return "resourceStorePath";
    }

    @Override
    public Object doRun() throws Exception {
        ResourceStoreRequest req = new ResourceStoreRequest(this.getResourceStorePath());
        if (StringUtils.isEmpty((String)this.getRepositoryId())) {
            List<MavenRepository> reposes = this.getRepositoryRegistry().getRepositoriesWithFacet(MavenRepository.class);
            TaskUtil.getCurrentProgressListener().beginTask("Recreating Maven Metadata on all Maven repositories", reposes.size());
            for (MavenRepository repo : reposes) {
                TaskUtil.getCurrentProgressListener().working(RepositoryStringUtils.getFormattedMessage("Recreating Maven Metadata on %s", repo), 1);
                repo.recreateMavenMetadata(req);
            }
            TaskUtil.getCurrentProgressListener().endTask("Done");
        } else {
            Repository repository = this.getRepositoryRegistry().getRepository(this.getRepositoryId());
            if (repository.getRepositoryKind().isFacetAvailable(MavenRepository.class)) {
                MavenRepository mavenRepository = repository.adaptToFacet(MavenRepository.class);
                TaskUtil.getCurrentProgressListener().beginTask(RepositoryStringUtils.getFormattedMessage("Recreating Maven Metadata on %s", mavenRepository));
                mavenRepository.recreateMavenMetadata(req);
                TaskUtil.getCurrentProgressListener().endTask("Done");
            } else {
                this.getLogger().info(RepositoryStringUtils.getFormattedMessage("Repository %s is not a Maven repository. Will not rebuild maven metadata, but the task seems wrongly configured!", repository));
            }
        }
        return null;
    }

    @Override
    protected String getAction() {
        return REBUILD_MAVEN_METADATA_ACTION;
    }

    @Override
    protected String getMessage() {
        if (this.getRepositoryId() != null) {
            return "Rebuilding maven metadata of repository " + this.getRepositoryName() + " from path " + this.getResourceStorePath() + " and below.";
        }
        return "Rebuilding maven metadata of all registered repositories";
    }
}

