/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.maven.tasks;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.aether.util.version.GenericVersionScheme;
import org.sonatype.aether.version.InvalidVersionSpecificationException;
import org.sonatype.aether.version.Version;
import org.sonatype.aether.version.VersionScheme;
import org.sonatype.nexus.maven.tasks.AbstractFileDeletingWalkerProcessor;
import org.sonatype.nexus.maven.tasks.SnapshotRemovalRepositoryResult;
import org.sonatype.nexus.maven.tasks.SnapshotRemovalRequest;
import org.sonatype.nexus.maven.tasks.SnapshotRemovalResult;
import org.sonatype.nexus.maven.tasks.SnapshotRemover;
import org.sonatype.nexus.proxy.ItemNotFoundException;
import org.sonatype.nexus.proxy.NoSuchRepositoryException;
import org.sonatype.nexus.proxy.RequestContext;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.item.StorageCollectionItem;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.maven.MavenHostedRepository;
import org.sonatype.nexus.proxy.maven.MavenProxyRepository;
import org.sonatype.nexus.proxy.maven.MavenRepository;
import org.sonatype.nexus.proxy.maven.RecreateMavenMetadataWalkerProcessor;
import org.sonatype.nexus.proxy.maven.RepositoryPolicy;
import org.sonatype.nexus.proxy.maven.gav.Gav;
import org.sonatype.nexus.proxy.registry.ContentClass;
import org.sonatype.nexus.proxy.registry.RepositoryRegistry;
import org.sonatype.nexus.proxy.repository.GroupRepository;
import org.sonatype.nexus.proxy.repository.HostedRepository;
import org.sonatype.nexus.proxy.repository.ProxyRepository;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.walker.DefaultWalkerContext;
import org.sonatype.nexus.proxy.walker.DottedStoreWalkerFilter;
import org.sonatype.nexus.proxy.walker.ParentOMatic;
import org.sonatype.nexus.proxy.walker.Walker;
import org.sonatype.nexus.proxy.walker.WalkerContext;
import org.sonatype.nexus.proxy.walker.WalkerException;
import org.sonatype.nexus.proxy.wastebasket.DeleteOperation;
import org.sonatype.nexus.util.PathUtils;
import org.sonatype.scheduling.TaskUtil;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Named
@Singleton
public class DefaultSnapshotRemover
extends ComponentSupport
implements SnapshotRemover {
    private RepositoryRegistry repositoryRegistry;
    private Walker walker;
    private ContentClass maven2ContentClass;
    private VersionScheme versionScheme = new GenericVersionScheme();

    @Inject
    public DefaultSnapshotRemover(RepositoryRegistry repositoryRegistry, Walker walker, @Named(value="maven2") ContentClass maven2ContentClass) {
        this.repositoryRegistry = (RepositoryRegistry)Preconditions.checkNotNull((Object)repositoryRegistry);
        this.walker = (Walker)Preconditions.checkNotNull((Object)walker);
        this.maven2ContentClass = (ContentClass)Preconditions.checkNotNull((Object)maven2ContentClass);
    }

    protected RepositoryRegistry getRepositoryRegistry() {
        return this.repositoryRegistry;
    }

    @Override
    public SnapshotRemovalResult removeSnapshots(SnapshotRemovalRequest request) throws NoSuchRepositoryException, IllegalArgumentException {
        SnapshotRemovalResult result = new SnapshotRemovalResult();
        this.logDetails(request);
        if (request.getRepositoryId() != null) {
            Repository repository = this.getRepositoryRegistry().getRepository(request.getRepositoryId());
            if (!this.process(request, result, repository)) {
                throw new IllegalArgumentException("The repository with ID=" + repository.getId() + " is not valid for Snapshot Removal Task!");
            }
        } else {
            for (Repository repository : this.getRepositoryRegistry().getRepositories()) {
                this.process(request, result, repository);
            }
        }
        return result;
    }

    private void process(SnapshotRemovalRequest request, SnapshotRemovalResult result, GroupRepository group) {
        for (Repository repository : group.getMemberRepositories()) {
            this.process(request, result, repository);
        }
    }

    private boolean process(SnapshotRemovalRequest request, SnapshotRemovalResult result, Repository repository) {
        if (!repository.getRepositoryContentClass().isCompatible(this.maven2ContentClass)) {
            this.log.debug("Skipping '" + repository.getId() + "' is not a maven 2 repository");
            return false;
        }
        if (!repository.getLocalStatus().shouldServiceRequest()) {
            this.log.debug("Skipping '" + repository.getId() + "' the repository is out of service");
            return false;
        }
        if (repository.getRepositoryKind().isFacetAvailable(ProxyRepository.class)) {
            this.log.debug("Skipping '" + repository.getId() + "' is a proxy repository");
            return false;
        }
        if (repository.getRepositoryKind().isFacetAvailable(GroupRepository.class)) {
            this.process(request, result, repository.adaptToFacet(GroupRepository.class));
        } else if (repository.getRepositoryKind().isFacetAvailable(MavenRepository.class)) {
            result.addResult(this.removeSnapshotsFromMavenRepository(repository.adaptToFacet(MavenRepository.class), request));
        }
        return true;
    }

    protected SnapshotRemovalRepositoryResult removeSnapshotsFromMavenRepository(MavenRepository repository, SnapshotRemovalRequest request) {
        TaskUtil.checkInterruption();
        SnapshotRemovalRepositoryResult result = new SnapshotRemovalRepositoryResult(repository.getId(), 0, 0, true);
        if (!repository.getLocalStatus().shouldServiceRequest()) {
            return result;
        }
        if (request.isProcessedRepo(repository.getId())) {
            return new SnapshotRemovalRepositoryResult(repository.getId(), true);
        }
        request.addProcessedRepo(repository.getId());
        if (!RepositoryPolicy.SNAPSHOT.equals((Object)repository.getRepositoryPolicy())) {
            return result;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Collecting deletable snapshots on repository " + repository.getId() + " from storage directory " + repository.getLocalUrl());
        }
        ParentOMatic parentOMatic = new ParentOMatic();
        SnapshotRemoverWalkerProcessor snapshotRemoveProcessor = new SnapshotRemoverWalkerProcessor(repository, request, parentOMatic);
        DefaultWalkerContext ctxMain = new DefaultWalkerContext(repository, new ResourceStoreRequest("/"), new DottedStoreWalkerFilter(), WalkerContext.TraversalType.BREADTH_FIRST, false);
        ctxMain.getContext().put(DeleteOperation.DELETE_OPERATION_CTX_KEY, (Object)this.getDeleteOperation(request));
        ctxMain.getProcessors().add(snapshotRemoveProcessor);
        this.walker.walk(ctxMain);
        if (ctxMain.getStopCause() != null) {
            result.setSuccessful(false);
        }
        result.setDeletedSnapshots(snapshotRemoveProcessor.getDeletedSnapshots());
        result.setDeletedFiles(snapshotRemoveProcessor.getDeletedFiles());
        if (this.log.isInfoEnabled()) {
            this.log.info("deleted {} snapshot builds containing {} files on repository {}", new Object[]{snapshotRemoveProcessor.getDeletedSnapshots(), snapshotRemoveProcessor.getDeletedFiles(), repository.getId()});
        }
        if (repository.getRepositoryKind().isFacetAvailable(HostedRepository.class)) {
            repository.expireNotFoundCaches(new ResourceStoreRequest("/"));
            RecreateMavenMetadataWalkerProcessor metadataRebuildProcessor = new RecreateMavenMetadataWalkerProcessor(this.log, this.getDeleteOperation(request));
            List<String> markedPaths = parentOMatic.getMarkedPaths();
            if (this.log.isInfoEnabled()) {
                this.log.info("rebuilding metadata for {} paths on repository {}", (Object)(markedPaths != null ? markedPaths.size() : 0), (Object)repository.getId());
            }
            for (String path : markedPaths) {
                TaskUtil.checkInterruption();
                DefaultWalkerContext ctxMd = new DefaultWalkerContext(repository, new ResourceStoreRequest(path), new DottedStoreWalkerFilter());
                ctxMd.getProcessors().add(metadataRebuildProcessor);
                if (this.log.isTraceEnabled()) {
                    this.log.trace("rebuilding metadata for {} on repository {}", (Object)path, (Object)repository.getId());
                }
                try {
                    this.walker.walk(ctxMd);
                }
                catch (WalkerException e) {
                    if (e.getCause() instanceof ItemNotFoundException) continue;
                    throw e;
                }
            }
        }
        return result;
    }

    private DeleteOperation getDeleteOperation(SnapshotRemovalRequest request) {
        return request.isDeleteImmediately() ? DeleteOperation.DELETE_PERMANENTLY : DeleteOperation.MOVE_TO_TRASH;
    }

    private void logDetails(SnapshotRemovalRequest request) {
        if (request.getRepositoryId() != null) {
            this.log.info("Removing old SNAPSHOT deployments from " + request.getRepositoryId() + " repository.");
        } else {
            this.log.info("Removing old SNAPSHOT deployments from all repositories.");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("With parameters: ");
            this.log.debug("    MinCountOfSnapshotsToKeep: " + request.getMinCountOfSnapshotsToKeep());
            this.log.debug("    RemoveSnapshotsOlderThanDays: " + request.getRemoveSnapshotsOlderThanDays());
            this.log.debug("    RemoveIfReleaseExists: " + request.isRemoveIfReleaseExists());
            this.log.debug("    DeleteImmediately: " + request.isDeleteImmediately());
            this.log.debug("    UseLastRequestedTimestamp: " + request.shouldUseLastRequestedTimestamp());
        }
    }

    private class SnapshotRemoverWalkerProcessor
    extends AbstractFileDeletingWalkerProcessor {
        private static final long MILLIS_IN_A_DAY = 86400000L;
        private final MavenRepository repository;
        private final SnapshotRemovalRequest request;
        private final Map<Version, List<StorageFileItem>> toRemainSnapshotsAndFiles = Maps.newHashMap();
        private final Map<Version, List<StorageFileItem>> toDeleteSnapshotsAndFiles = Maps.newHashMap();
        private final ParentOMatic collectionNodes;
        private final long dateThreshold;
        private final long startTime;
        private final long gracePeriodInMillis;
        private final List<StorageItem> items;
        private boolean shouldProcessCollection;
        private boolean removeWholeGAV;
        private int deletedSnapshots = 0;
        private int deletedFiles = 0;

        public SnapshotRemoverWalkerProcessor(MavenRepository repository, SnapshotRemovalRequest request, ParentOMatic collectionNodes) {
            this.repository = repository;
            this.request = request;
            this.collectionNodes = collectionNodes;
            this.startTime = System.currentTimeMillis();
            int days = request.getRemoveSnapshotsOlderThanDays();
            this.dateThreshold = days > 0 ? this.startTime - (long)days * 86400000L : -1L;
            this.gracePeriodInMillis = (long)Math.max(0, request.getGraceDaysAfterRelease()) * 86400000L;
            this.items = Lists.newArrayList();
        }

        protected void addStorageFileItemToMap(Map<Version, List<StorageFileItem>> map, Gav gav, StorageFileItem item) {
            Version key = null;
            try {
                key = DefaultSnapshotRemover.this.versionScheme.parseVersion(gav.getVersion());
            }
            catch (InvalidVersionSpecificationException e) {
                try {
                    key = DefaultSnapshotRemover.this.versionScheme.parseVersion("0.0-SNAPSHOT");
                }
                catch (InvalidVersionSpecificationException invalidVersionSpecificationException) {
                    // empty catch block
                }
            }
            if (!map.containsKey(key)) {
                map.put(key, new ArrayList());
            }
            map.get(key).add(item);
        }

        @Override
        public void onCollectionEnter(WalkerContext context, StorageCollectionItem coll) {
            this.items.clear();
            this.toDeleteSnapshotsAndFiles.clear();
            this.toRemainSnapshotsAndFiles.clear();
            this.shouldProcessCollection = coll.getPath().endsWith("SNAPSHOT");
        }

        @Override
        public void processItem(WalkerContext context, StorageItem item) throws Exception {
            if (!this.shouldProcessCollection) {
                return;
            }
            this.items.add(item);
        }

        @Override
        public void onCollectionExit(WalkerContext context, StorageCollectionItem coll) {
            if (!this.shouldProcessCollection) {
                return;
            }
            try {
                this.doOnCollectionExit(context, coll);
            }
            catch (Exception e) {
                DefaultSnapshotRemover.this.log.warn("SnapshotRemover is failed to process path: '" + coll.getPath() + "'.", (Throwable)e);
            }
        }

        public void doOnCollectionExit(WalkerContext context, StorageCollectionItem coll) throws Exception {
            if (DefaultSnapshotRemover.this.log.isDebugEnabled()) {
                DefaultSnapshotRemover.this.log.debug("doOnCollectionExit() :: " + coll.getRepositoryItemUid().toString());
            }
            this.removeWholeGAV = false;
            HashSet versionsToRemove = Sets.newHashSet();
            boolean checkIfReleaseExists = this.request.isRemoveIfReleaseExists();
            HashMap uniqueBuildsNearestRequestTimes = Maps.newHashMap();
            for (StorageItem item : this.items) {
                if (item.isVirtual() || StorageCollectionItem.class.isAssignableFrom(item.getClass())) continue;
                Gav gav = ((MavenRepository)coll.getRepositoryItemUid().getRepository()).getGavCalculator().pathToGav(item.getPath());
                if (DefaultSnapshotRemover.this.log.isDebugEnabled()) {
                    DefaultSnapshotRemover.this.log.debug(item.getPath());
                }
                if (gav == null) continue;
                if (checkIfReleaseExists && !gav.isHash() && !gav.isSignature() && gav.getExtension().equals("pom")) {
                    checkIfReleaseExists = false;
                    if (this.releaseExistsForSnapshot(gav, item.getItemContext())) {
                        if (DefaultSnapshotRemover.this.log.isDebugEnabled()) {
                            DefaultSnapshotRemover.this.log.debug("release found");
                        }
                        this.removeWholeGAV = true;
                        break;
                    }
                    if (DefaultSnapshotRemover.this.log.isDebugEnabled()) {
                        DefaultSnapshotRemover.this.log.debug("release not found");
                    }
                }
                item.getItemContext().put(Gav.class.getName(), (Object)gav);
                if (gav.isHash() || gav.isSignature()) {
                    if (!DefaultSnapshotRemover.this.log.isTraceEnabled()) continue;
                    DefaultSnapshotRemover.this.log.trace("Skipping lastRequested for: {}", (Object)item.getPath());
                    continue;
                }
                if (gav.getSnapshotTimeStamp() != null) {
                    long mavenSnapshotTimestamp = gav.getSnapshotTimeStamp();
                    if (DefaultSnapshotRemover.this.log.isDebugEnabled()) {
                        DefaultSnapshotRemover.this.log.debug("itemTimestamp={} ({}), dateThreshold={} ({})", new Object[]{mavenSnapshotTimestamp, mavenSnapshotTimestamp > 0L ? new Date(mavenSnapshotTimestamp) : "", this.dateThreshold, this.dateThreshold > 0L ? new Date(this.dateThreshold) : ""});
                    }
                    if (-1L == this.dateThreshold) {
                        versionsToRemove.add(mavenSnapshotTimestamp);
                        this.addStorageFileItemToMap(this.toDeleteSnapshotsAndFiles, gav, (StorageFileItem)item);
                        continue;
                    }
                    if (versionsToRemove.contains(mavenSnapshotTimestamp)) {
                        this.addStorageFileItemToMap(this.toDeleteSnapshotsAndFiles, gav, (StorageFileItem)item);
                        continue;
                    }
                    if (this.request.shouldUseLastRequestedTimestamp()) {
                        Integer uniqueSnapKey = gav.getSnapshotBuildNumber();
                        CacheEntry previouslyCached = (CacheEntry)uniqueBuildsNearestRequestTimes.get(uniqueSnapKey);
                        if (previouslyCached == null) {
                            uniqueBuildsNearestRequestTimes.put(uniqueSnapKey, new CacheEntry((StorageFileItem)item, gav));
                            continue;
                        }
                        previouslyCached.addItem((StorageFileItem)item);
                        continue;
                    }
                    if (mavenSnapshotTimestamp < this.dateThreshold) {
                        DefaultSnapshotRemover.this.log.trace("maven timestamp {} earlier than threshold {}", (Object)mavenSnapshotTimestamp, (Object)this.dateThreshold);
                        versionsToRemove.add(mavenSnapshotTimestamp);
                        this.addStorageFileItemToMap(this.toDeleteSnapshotsAndFiles, gav, (StorageFileItem)item);
                        continue;
                    }
                    DefaultSnapshotRemover.this.log.trace("retain date satisfied {}", (Object)item.getName());
                    this.addStorageFileItemToMap(this.toRemainSnapshotsAndFiles, gav, (StorageFileItem)item);
                    continue;
                }
                DefaultSnapshotRemover.this.log.debug("GAV Snapshot timestamp not available, skipping non-unique snapshot");
                this.addStorageFileItemToMap(this.toRemainSnapshotsAndFiles, gav, (StorageFileItem)item);
            }
            if (this.removeWholeGAV) {
                try {
                    for (StorageItem item : this.items) {
                        try {
                            if (item instanceof StorageCollectionItem) continue;
                            this.repository.deleteItem(false, this.createResourceStoreRequest(item, context));
                        }
                        catch (ItemNotFoundException e) {
                            if (!DefaultSnapshotRemover.this.log.isDebugEnabled()) continue;
                            DefaultSnapshotRemover.this.log.debug("Could not delete whole GAV " + coll.getRepositoryItemUid().toString(), (Throwable)e);
                        }
                    }
                }
                catch (Exception e) {
                    DefaultSnapshotRemover.this.log.warn("Could not delete whole GAV " + coll.getRepositoryItemUid().toString(), (Throwable)e);
                }
            } else {
                if (!uniqueBuildsNearestRequestTimes.isEmpty()) {
                    DefaultSnapshotRemover.this.log.debug("processing {} cached builds by most recently requested date", (Object)uniqueBuildsNearestRequestTimes.size());
                    for (CacheEntry entry : uniqueBuildsNearestRequestTimes.values()) {
                        if (entry.mostRecentItemLastRequested < this.dateThreshold) {
                            for (StorageFileItem sfi : entry.items) {
                                if (DefaultSnapshotRemover.this.log.isTraceEnabled()) {
                                    DefaultSnapshotRemover.this.log.trace("remove: {} most recent lastRequested={} ({}),dateThreshold={} ({})", new Object[]{sfi.getName(), entry.mostRecentItemLastRequested, entry.mostRecentItemLastRequested > 0L ? new Date(entry.mostRecentItemLastRequested) : "", this.dateThreshold, this.dateThreshold > 0L ? new Date(this.dateThreshold) : ""});
                                }
                                this.addStorageFileItemToMap(this.toDeleteSnapshotsAndFiles, entry.gav, sfi);
                            }
                            continue;
                        }
                        for (StorageFileItem sfi : entry.items) {
                            if (DefaultSnapshotRemover.this.log.isTraceEnabled()) {
                                DefaultSnapshotRemover.this.log.trace("retain: {} most recent lastRequested={} ({}),dateThreshold={} ({})", new Object[]{sfi.getName(), entry.mostRecentItemLastRequested, entry.mostRecentItemLastRequested > 0L ? new Date(entry.mostRecentItemLastRequested) : "", this.dateThreshold, this.dateThreshold > 0L ? new Date(this.dateThreshold) : ""});
                            }
                            this.addStorageFileItemToMap(this.toRemainSnapshotsAndFiles, entry.gav, sfi);
                        }
                    }
                }
                if (this.toRemainSnapshotsAndFiles.size() < this.request.getMinCountOfSnapshotsToKeep()) {
                    if (this.toRemainSnapshotsAndFiles.size() + this.toDeleteSnapshotsAndFiles.size() < this.request.getMinCountOfSnapshotsToKeep()) {
                        this.toDeleteSnapshotsAndFiles.clear();
                    } else {
                        TreeSet<Version> keys = new TreeSet<Version>(this.toDeleteSnapshotsAndFiles.keySet());
                        while (!keys.isEmpty() && this.toRemainSnapshotsAndFiles.size() < this.request.getMinCountOfSnapshotsToKeep()) {
                            Version keyToMove = keys.last();
                            if (this.toRemainSnapshotsAndFiles.containsKey(keyToMove)) {
                                this.toRemainSnapshotsAndFiles.get(keyToMove).addAll((Collection<StorageFileItem>)this.toDeleteSnapshotsAndFiles.get(keyToMove));
                            } else {
                                this.toRemainSnapshotsAndFiles.put(keyToMove, this.toDeleteSnapshotsAndFiles.get(keyToMove));
                            }
                            this.toDeleteSnapshotsAndFiles.remove(keyToMove);
                            keys.remove(keyToMove);
                        }
                    }
                }
                boolean gavHasMoreTimestampedSnapshots = this.toRemainSnapshotsAndFiles.size() > 0;
                for (Version key : this.toDeleteSnapshotsAndFiles.keySet()) {
                    List<StorageFileItem> files = this.toDeleteSnapshotsAndFiles.get(key);
                    ++this.deletedSnapshots;
                    for (StorageFileItem file : files) {
                        try {
                            if (gavHasMoreTimestampedSnapshots) {
                                file.getItemContext().put("moreTsSnapshotsExistsForGav", (Object)Boolean.TRUE);
                            }
                            this.repository.deleteItem(false, this.createResourceStoreRequest(file, context));
                            ++this.deletedFiles;
                        }
                        catch (ItemNotFoundException e) {
                            if (!DefaultSnapshotRemover.this.log.isTraceEnabled()) continue;
                            DefaultSnapshotRemover.this.log.trace("Could not delete file:", (Throwable)e);
                        }
                        catch (Exception e) {
                            DefaultSnapshotRemover.this.log.info("Could not delete file:", (Throwable)e);
                        }
                    }
                }
            }
            this.removeDirectoryIfEmpty(this.repository, coll);
            this.updateMetadataIfNecessary(context, coll);
        }

        private void updateMetadataIfNecessary(WalkerContext context, StorageCollectionItem coll) throws Exception {
            if (!this.toDeleteSnapshotsAndFiles.isEmpty() && this.toRemainSnapshotsAndFiles.isEmpty()) {
                this.collectionNodes.addAndMarkPath(PathUtils.getParentPath(coll.getPath()));
            } else {
                this.collectionNodes.addAndMarkPath(coll.getPath());
            }
        }

        public boolean releaseExistsForSnapshot(Gav snapshotGav, RequestContext context) {
            long releaseTimestamp = -1L;
            for (Repository repository : DefaultSnapshotRemover.this.repositoryRegistry.getRepositories()) {
                MavenRepository mrepository;
                if (!repository.getRepositoryKind().isFacetAvailable(MavenHostedRepository.class) && !repository.getRepositoryKind().isFacetAvailable(MavenProxyRepository.class) || !(mrepository = repository.adaptToFacet(MavenRepository.class)).isUserManaged() || !RepositoryPolicy.RELEASE.equals((Object)mrepository.getRepositoryPolicy())) continue;
                try {
                    String releaseVersion = null;
                    releaseVersion = snapshotGav.getBaseVersion().endsWith("-SNAPSHOT") ? snapshotGav.getBaseVersion().substring(0, snapshotGav.getBaseVersion().length() - 9) : snapshotGav.getBaseVersion().substring(0, snapshotGav.getBaseVersion().length() - 8);
                    Gav releaseGav = new Gav(snapshotGav.getGroupId(), snapshotGav.getArtifactId(), releaseVersion, snapshotGav.getClassifier(), snapshotGav.getExtension(), null, null, null, false, null, false, null);
                    String path = mrepository.getGavCalculator().gavToPath(releaseGav);
                    ResourceStoreRequest req = new ResourceStoreRequest(path, true, false);
                    req.getRequestContext().setParentContext(context);
                    DefaultSnapshotRemover.this.log.debug("Checking for release counterpart in repository '{}' and path '{}'", (Object)mrepository.getId(), (Object)req.toString());
                    StorageItem item = mrepository.retrieveItem(false, req);
                    releaseTimestamp = item.getCreated();
                    break;
                }
                catch (ItemNotFoundException releaseVersion) {
                }
                catch (Exception e) {
                    DefaultSnapshotRemover.this.log.debug("Unexpected exception!", (Throwable)e);
                }
            }
            return releaseTimestamp == 0L || releaseTimestamp > 0L && this.startTime > releaseTimestamp + this.gracePeriodInMillis;
        }

        public int getDeletedSnapshots() {
            return this.deletedSnapshots;
        }

        public int getDeletedFiles() {
            return this.deletedFiles;
        }
    }

    private static class CacheEntry {
        private final List<StorageFileItem> items = Lists.newArrayList();
        private Long mostRecentItemLastRequested;
        private final Gav gav;

        CacheEntry(StorageFileItem item, Gav gav) {
            this.addItem(item);
            this.gav = (Gav)Preconditions.checkNotNull((Object)gav);
        }

        void addItem(StorageFileItem item) {
            this.items.add((StorageFileItem)Preconditions.checkNotNull((Object)item));
            if (this.mostRecentItemLastRequested == null || item.getLastRequested() > this.mostRecentItemLastRequested) {
                this.mostRecentItemLastRequested = item.getLastRequested();
            }
        }
    }
}

