/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.maven.tasks;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.maven.tasks.ReleaseRemovalRequest;
import org.sonatype.nexus.maven.tasks.ReleaseRemovalResult;
import org.sonatype.nexus.maven.tasks.ReleaseRemover;
import org.sonatype.nexus.maven.tasks.ReleaseRemoverBackend;
import org.sonatype.nexus.proxy.NoSuchRepositoryException;
import org.sonatype.nexus.proxy.maven.MavenRepository;
import org.sonatype.nexus.proxy.maven.RepositoryPolicy;
import org.sonatype.nexus.proxy.registry.ContentClass;
import org.sonatype.nexus.proxy.registry.RepositoryRegistry;
import org.sonatype.nexus.proxy.repository.GroupRepository;
import org.sonatype.nexus.proxy.repository.ProxyRepository;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.targets.Target;
import org.sonatype.nexus.proxy.targets.TargetRegistry;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Named
@Singleton
public class DefaultReleaseRemover
extends ComponentSupport
implements ReleaseRemover {
    private final RepositoryRegistry repositoryRegistry;
    private final TargetRegistry targetRegistry;
    private final ContentClass maven2ContentClass;
    private final Map<String, ReleaseRemoverBackend> backends;

    @Inject
    public DefaultReleaseRemover(RepositoryRegistry repositoryRegistry, TargetRegistry targetRegistry, @Named(value="maven2") ContentClass maven2ContentClass, Map<String, ReleaseRemoverBackend> backends) {
        this.repositoryRegistry = (RepositoryRegistry)Preconditions.checkNotNull((Object)repositoryRegistry);
        this.targetRegistry = (TargetRegistry)Preconditions.checkNotNull((Object)targetRegistry);
        this.maven2ContentClass = (ContentClass)Preconditions.checkNotNull((Object)maven2ContentClass);
        this.backends = (Map)Preconditions.checkNotNull(backends);
    }

    @Override
    public ReleaseRemovalResult removeReleases(ReleaseRemovalRequest request) throws NoSuchRepositoryException {
        this.logDetails(request);
        ReleaseRemovalResult result = new ReleaseRemovalResult(request.getRepositoryId());
        Repository repository = this.repositoryRegistry.getRepository(request.getRepositoryId());
        Target repositoryTarget = this.targetRegistry.getRepositoryTarget(request.getTargetId());
        if (!Strings.isNullOrEmpty((String)request.getTargetId()) && repositoryTarget == null) {
            throw new IllegalStateException("The specified repository target does not exist. Perhaps it has been deleted since this repository target was configured? Target id = " + request.getTargetId());
        }
        if (!this.process(request, result, repository, repositoryTarget)) {
            throw new IllegalArgumentException("The repository with ID=" + repository.getId() + " is not valid for " + "ReleaseRemoverTask");
        }
        this.log.debug("Results of {} are: {}", (Object)"ReleaseRemoverTask", (Object)result);
        return result;
    }

    private boolean process(ReleaseRemovalRequest request, ReleaseRemovalResult result, Repository repository, Target repositoryTarget) {
        if (!repository.getRepositoryContentClass().isCompatible(this.maven2ContentClass)) {
            this.log.debug("Skipping '{}' is not a maven 2 repository", (Object)repository.getId());
            return false;
        }
        if (!repository.getLocalStatus().shouldServiceRequest()) {
            this.log.debug("Skipping '{}' because the repository is out of service", (Object)repository.getId());
            return false;
        }
        if (repository.getRepositoryKind().isFacetAvailable(ProxyRepository.class)) {
            this.log.debug("Skipping '{}' because it is a proxy repository", (Object)repository.getId());
            return false;
        }
        if (repository.getRepositoryKind().isFacetAvailable(GroupRepository.class)) {
            this.log.debug("Skipping '{}' because it is a group repository", (Object)repository.getId());
            return false;
        }
        MavenRepository mavenRepository = repository.adaptToFacet(MavenRepository.class);
        if (mavenRepository == null) {
            this.log.debug("Skipping '{}' because it could not be adapted to MavenRepository", (Object)repository.getId());
            return false;
        }
        if (!RepositoryPolicy.RELEASE.equals((Object)mavenRepository.getRepositoryPolicy())) {
            this.log.debug("Skipping '{}' because it is a snapshot or mixed repository", (Object)repository.getId());
            return false;
        }
        try {
            ReleaseRemoverBackend backend = request.isUseIndex() ? (ReleaseRemoverBackend)Preconditions.checkNotNull((Object)this.backends.get("index"), (Object)"Index backend not found") : (ReleaseRemoverBackend)Preconditions.checkNotNull((Object)this.backends.get("walker"), (Object)"Walker backend not found");
            backend.removeReleases(request, result, mavenRepository, repositoryTarget);
            return true;
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private void logDetails(ReleaseRemovalRequest request) {
        this.log.info("Removing older releases from repository: {}", (Object)request.getRepositoryId());
        if (this.log.isDebugEnabled()) {
            this.log.debug("With parameters: ");
            this.log.debug("    NumberOfVersionsToKeep: {}", (Object)request.getNumberOfVersionsToKeep());
            this.log.debug("    RepositoryTarget applied: {}", (Object)request.getTargetId());
        }
    }
}

