/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.maven.tasks;

import org.sonatype.nexus.proxy.IllegalOperationException;
import org.sonatype.nexus.proxy.ItemNotFoundException;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.StorageException;
import org.sonatype.nexus.proxy.item.StorageCollectionItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.maven.MavenRepository;
import org.sonatype.nexus.proxy.storage.UnsupportedStorageOperationException;
import org.sonatype.nexus.proxy.walker.AbstractWalkerProcessor;
import org.sonatype.nexus.proxy.walker.WalkerContext;
import org.sonatype.nexus.proxy.wastebasket.DeleteOperation;

public abstract class AbstractFileDeletingWalkerProcessor
extends AbstractWalkerProcessor {
    protected void removeDirectoryIfEmpty(MavenRepository repository, StorageCollectionItem coll) throws StorageException, IllegalOperationException, UnsupportedStorageOperationException {
        try {
            if (repository.list(false, coll).size() > 0) {
                return;
            }
            repository.deleteItem(false, this.createResourceStoreRequest(coll, DeleteOperation.DELETE_PERMANENTLY));
        }
        catch (ItemNotFoundException itemNotFoundException) {
            // empty catch block
        }
    }

    protected ResourceStoreRequest createResourceStoreRequest(StorageItem item, WalkerContext ctx) {
        ResourceStoreRequest request = new ResourceStoreRequest(item);
        if (ctx.getContext().containsKey(DeleteOperation.DELETE_OPERATION_CTX_KEY)) {
            request.getRequestContext().put(DeleteOperation.DELETE_OPERATION_CTX_KEY, ctx.getContext().get(DeleteOperation.DELETE_OPERATION_CTX_KEY));
        }
        return request;
    }

    protected ResourceStoreRequest createResourceStoreRequest(StorageCollectionItem item, DeleteOperation operation) {
        ResourceStoreRequest request = new ResourceStoreRequest(item);
        request.getRequestContext().put(DeleteOperation.DELETE_OPERATION_CTX_KEY, (Object)operation);
        return request;
    }
}

