/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.log.internal;

import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.xml.parsers.SAXParserFactory;
import org.sonatype.nexus.log.LoggerLevel;
import org.sonatype.sisu.goodies.common.io.FileReplacer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@Singleton
@Named
public class LogbackOverrides {
    private LogbackOverrides() {
    }

    static Map<String, LoggerLevel> read(File overridesXml) {
        try {
            final HashMap loggers = Maps.newHashMap();
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setValidating(false);
            spf.setNamespaceAware(true);
            spf.newSAXParser().parse(overridesXml, new DefaultHandler(){

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    if ("logger".equals(localName)) {
                        String name = attributes.getValue("name");
                        String level = attributes.getValue("level");
                        loggers.put(name, LoggerLevel.valueOf(level));
                    }
                }
            });
            return loggers;
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    static void write(File overridesXml, final Map<String, LoggerLevel> overrides) {
        try {
            FileReplacer fileReplacer = new FileReplacer(overridesXml);
            fileReplacer.setDeleteBackupFile(true);
            fileReplacer.replace(new FileReplacer.ContentWriter(){

                public void write(BufferedOutputStream output) throws IOException {
                    try (PrintWriter out = new PrintWriter(output);){
                        out.println("<?xml version='1.0' encoding='UTF-8'?>");
                        out.println();
                        out.println("<!--");
                        out.println("    DO NOT EDIT - This file includes user customised loggers and is automatically generated.");
                        out.println("-->");
                        out.println();
                        out.println("<included>");
                        for (Map.Entry entry : overrides.entrySet()) {
                            out.println(String.format("  <logger name=\"%s\" level=\"%s\"/>", entry.getKey(), ((LoggerLevel)((Object)entry.getValue())).toString()));
                        }
                        out.write("</included>");
                    }
                }
            });
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

