/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.log.internal;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.jul.LevelChangePropagator;
import ch.qos.logback.classic.spi.LoggerContextListener;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.util.StatusPrinter;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Injector;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.LimitedInputStream;
import org.sonatype.nexus.NexusStreamResponse;
import org.sonatype.nexus.configuration.application.ApplicationConfiguration;
import org.sonatype.nexus.log.DefaultLogConfiguration;
import org.sonatype.nexus.log.DefaultLogManagerMBean;
import org.sonatype.nexus.log.LogConfiguration;
import org.sonatype.nexus.log.LogConfigurationCustomizer;
import org.sonatype.nexus.log.LogConfigurationParticipant;
import org.sonatype.nexus.log.LogManager;
import org.sonatype.nexus.log.LoggerLevel;
import org.sonatype.nexus.log.internal.LogbackOverrides;
import org.sonatype.nexus.proxy.events.NexusInitializedEvent;
import org.sonatype.nexus.util.file.FileSupport;
import org.sonatype.nexus.util.io.StreamSupport;
import org.sonatype.sisu.goodies.common.io.FileReplacer;
import org.sonatype.sisu.goodies.eventbus.EventBus;

@Singleton
@Named
public class LogbackLogManager
implements LogManager {
    private static final String JMX_DOMAIN = "org.sonatype.nexus.log";
    private static final String KEY_APPENDER_FILE = "appender.file";
    private static final String KEY_APPENDER_PATTERN = "appender.pattern";
    private static final String KEY_ROOT_LEVEL = "root.level";
    private static final String KEY_LOG_CONFIG_DIR = "nexus.log-config-dir";
    private static final String LOG_CONF = "logback.xml";
    private static final String LOG_CONF_PROPS = "logback.properties";
    private static final String LOG_CONF_PROPS_RESOURCE = "/META-INF/log/logback.properties";
    private final Logger logger = LoggerFactory.getLogger(LogbackLogManager.class);
    private final Injector injector;
    private final ApplicationConfiguration applicationConfiguration;
    private final List<LogConfigurationParticipant> logConfigurationParticipants;
    private final List<LogConfigurationCustomizer> logConfigurationCustomizers;
    private final NexusLoggerContextListener loggerContextListener;
    private final EventBus eventBus;
    private final Map<String, LoggerLevel> overrides;
    private final Map<String, LoggerLevel> customisations;
    private ObjectName jmxName;

    @Inject
    public LogbackLogManager(Injector injector, ApplicationConfiguration applicationConfiguration, List<LogConfigurationParticipant> logConfigurationParticipants, List<LogConfigurationCustomizer> logConfigurationCustomizers, EventBus eventBus) {
        this.injector = (Injector)Preconditions.checkNotNull((Object)injector);
        this.applicationConfiguration = (ApplicationConfiguration)Preconditions.checkNotNull((Object)applicationConfiguration);
        this.logConfigurationParticipants = (List)Preconditions.checkNotNull(logConfigurationParticipants);
        this.logConfigurationCustomizers = (List)Preconditions.checkNotNull(logConfigurationCustomizers);
        this.loggerContextListener = new NexusLoggerContextListener();
        this.eventBus = (EventBus)Preconditions.checkNotNull((Object)eventBus);
        this.overrides = Maps.newHashMap();
        this.customisations = Maps.newHashMap();
        try {
            this.jmxName = ObjectName.getInstance(JMX_DOMAIN, "name", LogManager.class.getSimpleName());
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            server.registerMBean(new DefaultLogManagerMBean(this), this.jmxName);
        }
        catch (Exception e) {
            this.jmxName = null;
            this.logger.warn("Problem registering MBean for: " + this.getClass().getName(), (Throwable)e);
        }
        eventBus.register((Object)this);
    }

    @Subscribe
    public void on(NexusInitializedEvent evt) {
        this.configure();
    }

    private LoggerContext getLoggerContext() {
        return (LoggerContext)LoggerFactory.getILoggerFactory();
    }

    @Override
    public synchronized void configure() {
        this.prepareConfigurationFiles();
        this.readCustomisations();
        this.overrides.clear();
        File logOverridesConfigFile = this.getLogOverridesConfigFile();
        if (logOverridesConfigFile.exists()) {
            this.overrides.putAll(LogbackOverrides.read(logOverridesConfigFile));
        }
        this.mayInstallNexusLoggerContextListener();
        this.reconfigure();
    }

    @Override
    public synchronized void shutdown() {
        if (null != this.jmxName) {
            try {
                ManagementFactory.getPlatformMBeanServer().unregisterMBean(this.jmxName);
            }
            catch (Exception e) {
                this.logger.warn("Problem unregistering MBean for: " + this.getClass().getName(), (Throwable)e);
            }
        }
        this.eventBus.unregister((Object)this);
    }

    private File getLogConfigFile(String name) {
        return new File(this.getLogConfigDir(), name);
    }

    private File getLogOverridesConfigFile() {
        return this.getLogConfigFile("logback-overrides.xml");
    }

    @Override
    public Map<String, LoggerLevel> getLoggers() {
        HashMap loggers = Maps.newHashMap();
        LoggerContext loggerContext = this.getLoggerContext();
        for (ch.qos.logback.classic.Logger logger : loggerContext.getLoggerList()) {
            String name = logger.getName();
            Level level = logger.getLevel();
            if (level == null) continue;
            loggers.put(name, this.convert(level));
        }
        for (Map.Entry entry : this.customisations.entrySet()) {
            if (!LoggerLevel.DEFAULT.equals(entry.getValue()) || loggers.containsKey(entry.getKey())) continue;
            loggers.put(entry.getKey(), this.getLoggerEffectiveLevel((String)entry.getKey()));
        }
        return loggers;
    }

    @Override
    public Set<File> getLogFiles() {
        HashSet<File> files = new HashSet<File>();
        LoggerContext ctx = this.getLoggerContext();
        for (Logger l : ctx.getLoggerList()) {
            ch.qos.logback.classic.Logger log = (ch.qos.logback.classic.Logger)l;
            Iterator it = log.iteratorForAppenders();
            while (it.hasNext()) {
                Appender ap = (Appender)it.next();
                if (!(ap instanceof FileAppender) && !(ap instanceof RollingFileAppender)) continue;
                FileAppender fileAppender = (FileAppender)ap;
                String path = fileAppender.getFile();
                files.add(new File(path));
            }
        }
        return files;
    }

    @Override
    public File getLogFile(String filename) {
        Set<File> logFiles = this.getLogFiles();
        for (File logFile : logFiles) {
            if (!logFile.getName().equals(filename)) continue;
            return logFile;
        }
        return null;
    }

    @Override
    public LogConfiguration getConfiguration() throws IOException {
        Properties logProperties = this.loadConfigurationProperties();
        DefaultLogConfiguration configuration = new DefaultLogConfiguration();
        configuration.setRootLoggerLevel(logProperties.getProperty(KEY_ROOT_LEVEL));
        configuration.setRootLoggerAppenders("console,file");
        configuration.setFileAppenderPattern(logProperties.getProperty(KEY_APPENDER_PATTERN));
        configuration.setFileAppenderLocation(logProperties.getProperty(KEY_APPENDER_FILE));
        return configuration;
    }

    @Override
    public void setConfiguration(LogConfiguration configuration) throws IOException {
        Properties logProperties = this.loadConfigurationProperties();
        logProperties.setProperty(KEY_ROOT_LEVEL, configuration.getRootLoggerLevel());
        String pattern = configuration.getFileAppenderPattern();
        if (pattern == null) {
            pattern = this.getDefaultProperties().getProperty(KEY_APPENDER_PATTERN);
        }
        logProperties.setProperty(KEY_APPENDER_PATTERN, pattern);
        this.saveConfigurationProperties(logProperties);
        this.reconfigure();
    }

    private Properties getDefaultProperties() throws IOException {
        Properties properties = new Properties();
        try (InputStream stream = this.getClass().getResourceAsStream(LOG_CONF_PROPS_RESOURCE);){
            properties.load(stream);
        }
        return properties;
    }

    @Override
    public NexusStreamResponse getApplicationLogAsStream(String logFile, long from, long count) throws IOException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Retrieving " + logFile + " log file.");
        }
        if (logFile.contains(File.pathSeparator)) {
            this.logger.warn("Nexus refuses to retrieve log files with path separators in its name.");
            return null;
        }
        File log = this.getLogFile(logFile);
        if (log == null || !log.exists()) {
            this.logger.warn("Log file does not exist: [" + logFile + "]");
            return null;
        }
        NexusStreamResponse response = new NexusStreamResponse();
        response.setName(logFile);
        response.setMimeType("text/plain");
        response.setSize(log.length());
        if (count >= 0L) {
            response.setFromByte(from);
            response.setBytesCount(count);
        } else {
            response.setBytesCount(Math.abs(count));
            response.setFromByte(Math.max(0L, response.getSize() - response.getBytesCount()));
        }
        response.setInputStream(new LimitedInputStream(new FileInputStream(log), response.getFromByte(), response.getBytesCount()));
        return response;
    }

    private Properties loadConfigurationProperties() throws IOException {
        this.prepareConfigurationFiles();
        String logConfigDir = this.getLogConfigDir();
        File logConfigPropsFile = new File(logConfigDir, LOG_CONF_PROPS);
        try (FileInputStream in = new FileInputStream(logConfigPropsFile);){
            Properties properties = new Properties();
            properties.load(in);
            Properties properties2 = properties;
            return properties2;
        }
    }

    private void saveConfigurationProperties(final Properties properties) throws IOException {
        File configurationFile = new File(this.getLogConfigDir(), LOG_CONF_PROPS);
        this.logger.debug("Saving configuration: {}", (Object)configurationFile);
        FileReplacer fileReplacer = new FileReplacer(configurationFile);
        fileReplacer.setDeleteBackupFile(true);
        fileReplacer.replace(new FileReplacer.ContentWriter(){

            public void write(BufferedOutputStream output) throws IOException {
                properties.store(output, "Saved by Nexus");
            }
        });
    }

    private String getLogConfigDir() {
        String logConfigDir = System.getProperty(KEY_LOG_CONFIG_DIR);
        if (Strings.isNullOrEmpty((String)logConfigDir)) {
            logConfigDir = this.applicationConfiguration.getConfigurationDirectory().getAbsolutePath();
            System.setProperty(KEY_LOG_CONFIG_DIR, logConfigDir);
        }
        return logConfigDir;
    }

    private void prepareConfigurationFiles() {
        String logConfigDir = this.getLogConfigDir();
        File logConfigPropsFile = new File(logConfigDir, LOG_CONF_PROPS);
        if (!logConfigPropsFile.exists()) {
            try {
                URL configUrl = this.getClass().getResource(LOG_CONF_PROPS_RESOURCE);
                try (InputStream is = configUrl.openStream();){
                    FileSupport.copy(is, logConfigPropsFile.toPath());
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Could not create logback.properties as " + logConfigPropsFile.getAbsolutePath());
            }
        }
        if (this.logConfigurationParticipants != null) {
            for (final LogConfigurationParticipant participant : this.logConfigurationParticipants) {
                String name = participant.getName();
                File logConfigFile = new File(logConfigDir, name);
                if (!(participant instanceof LogConfigurationParticipant.NonEditable) && logConfigFile.exists()) continue;
                try {
                    FileReplacer fileReplacer = new FileReplacer(logConfigFile);
                    fileReplacer.setDeleteBackupFile(true);
                    fileReplacer.replace(new FileReplacer.ContentWriter(){

                        public void write(BufferedOutputStream output) throws IOException {
                            try (InputStream in = participant.getConfiguration();){
                                StreamSupport.copy(in, output, StreamSupport.BUFFER_SIZE);
                            }
                        }
                    });
                }
                catch (IOException e) {
                    throw new IllegalStateException(String.format("Could not create %s as %s", name, logConfigFile.getAbsolutePath()), e);
                }
            }
        }
        File logConfigFile = new File(logConfigDir, LOG_CONF);
        try {
            FileReplacer fileReplacer = new FileReplacer(logConfigFile);
            fileReplacer.setDeleteBackupFile(true);
            fileReplacer.replace(new FileReplacer.ContentWriter(){

                public void write(BufferedOutputStream output) throws IOException {
                    try (PrintWriter out = new PrintWriter(output);){
                        File logOverridesConfigFile;
                        out.println("<?xml version='1.0' encoding='UTF-8'?>");
                        out.println();
                        out.println("<!--");
                        out.println("    DO NOT EDIT - This file aggregates log configuration from Nexus and its plugins, and is automatically generated.");
                        out.println("-->");
                        out.println();
                        out.println("<configuration scan='true'>");
                        out.println("  <property file='${nexus.log-config-dir}/logback.properties'/>");
                        if (LogbackLogManager.this.logConfigurationParticipants != null) {
                            for (LogConfigurationParticipant participant : LogbackLogManager.this.logConfigurationParticipants) {
                                out.println(String.format("  <include file='${nexus.log-config-dir}/%s'/>", participant.getName()));
                            }
                        }
                        if ((logOverridesConfigFile = LogbackLogManager.this.getLogOverridesConfigFile()).exists()) {
                            out.println(String.format("  <include file='${nexus.log-config-dir}/%s'/>", logOverridesConfigFile.getName()));
                        }
                        out.write("</configuration>");
                    }
                }
            });
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not create logback.xml as " + logConfigFile.getAbsolutePath());
        }
    }

    private void reconfigure() {
        String logConfigDir = this.getLogConfigDir();
        File file = new File(logConfigDir, LOG_CONF);
        this.logger.debug("Reconfiguring: {}", (Object)file);
        LoggerContext context = this.getLoggerContext();
        try {
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext((Context)context);
            context.reset();
            context.getStatusManager().clear();
            this.installNonResetResistantListeners();
            configurator.doConfigure(file);
        }
        catch (JoranException e) {
            e.printStackTrace();
        }
        StatusPrinter.printInCaseOfErrorsOrWarnings((Context)context);
        this.injectAppenders();
    }

    private void installNonResetResistantListeners() {
        this.installLevelChangePropagator();
    }

    private void installLevelChangePropagator() {
        LoggerContext context = this.getLoggerContext();
        LevelChangePropagator levelChangePropagator = new LevelChangePropagator();
        levelChangePropagator.setResetJUL(true);
        levelChangePropagator.setContext((Context)context);
        context.addListener((LoggerContextListener)levelChangePropagator);
    }

    private void injectAppenders() {
        LoggerContext ctx = this.getLoggerContext();
        for (Logger l : ctx.getLoggerList()) {
            ch.qos.logback.classic.Logger log = (ch.qos.logback.classic.Logger)l;
            Iterator it = log.iteratorForAppenders();
            while (it.hasNext()) {
                Appender ap = (Appender)it.next();
                this.injector.injectMembers((Object)ap);
            }
        }
    }

    private LoggerLevel convert(Level level) {
        switch (level.toInt()) {
            case 0x7FFFFFFF: {
                return LoggerLevel.OFF;
            }
            case 40000: {
                return LoggerLevel.ERROR;
            }
            case 30000: {
                return LoggerLevel.WARN;
            }
            case 20000: {
                return LoggerLevel.INFO;
            }
            case 10000: {
                return LoggerLevel.DEBUG;
            }
            case 5000: {
                return LoggerLevel.TRACE;
            }
        }
        return LoggerLevel.TRACE;
    }

    private Level convert(LoggerLevel level) {
        return Level.valueOf((String)level.name());
    }

    @Override
    public void setLoggerLevel(String name, @Nullable LoggerLevel level) {
        if (level == null) {
            this.unsetLoggerLevel(name);
            return;
        }
        this.logger.debug("Set logger level: {}={}", (Object)name, (Object)level);
        LoggerLevel calculated = null;
        if ("ROOT".equals(name)) {
            try {
                calculated = LoggerLevel.DEFAULT.equals((Object)level) ? LoggerLevel.INFO : level;
                Properties logProperties = this.loadConfigurationProperties();
                logProperties.setProperty(KEY_ROOT_LEVEL, calculated.name());
                this.saveConfigurationProperties(logProperties);
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        } else if (LoggerLevel.DEFAULT.equals((Object)level)) {
            boolean customizedByUser = this.overrides.containsKey(name) && !this.customisations.containsKey(name);
            this.unsetLoggerLevel(name);
            if (customizedByUser) {
                calculated = this.getLoggerEffectiveLevel(name);
                this.overrides.put(name, calculated);
                LogbackOverrides.write(this.getLogOverridesConfigFile(), this.overrides);
            } else {
                LoggerLevel customizedLevel = this.customisations.get(name);
                if (customizedLevel != null && !LoggerLevel.DEFAULT.equals((Object)customizedLevel)) {
                    calculated = customizedLevel;
                }
            }
        } else {
            calculated = level;
            this.overrides.put(name, calculated);
            LogbackOverrides.write(this.getLogOverridesConfigFile(), this.overrides);
        }
        if (calculated != null) {
            this.setLogbackLoggerLevel(name, this.convert(calculated));
        }
    }

    @Override
    public void unsetLoggerLevel(String name) {
        this.logger.debug("Unset logger level: {}", (Object)name);
        if (this.overrides.remove(name) != null) {
            LogbackOverrides.write(this.getLogOverridesConfigFile(), this.overrides);
        }
        if ("ROOT".equals(name)) {
            this.setLoggerLevel(name, LoggerLevel.DEFAULT);
        } else {
            this.setLogbackLoggerLevel(name, null);
        }
    }

    @Override
    public void resetLoggers() {
        this.logger.debug("Resetting loggers");
        for (Map.Entry<String, LoggerLevel> entry : this.overrides.entrySet()) {
            if ("ROOT".equals(entry.getKey())) continue;
            this.setLogbackLoggerLevel(entry.getKey(), null);
        }
        this.overrides.clear();
        LogbackOverrides.write(this.getLogOverridesConfigFile(), this.overrides);
        this.setLoggerLevel("ROOT", LoggerLevel.DEFAULT);
        this.applyCustomisations();
        this.logger.debug("Loggers reset to their default levels");
    }

    @Override
    @Nullable
    public LoggerLevel getLoggerLevel(String name) {
        Level level = this.getLoggerContext().getLogger(name).getLevel();
        if (level != null) {
            return this.convert(level);
        }
        return null;
    }

    @Override
    public LoggerLevel getLoggerEffectiveLevel(String name) {
        return this.convert(this.getLoggerContext().getLogger(name).getEffectiveLevel());
    }

    private void setLogbackLoggerLevel(String name, Level level) {
        this.getLoggerContext().getLogger(name).setLevel(level);
    }

    private void mayInstallNexusLoggerContextListener() {
        LoggerContext context = this.getLoggerContext();
        if (!context.getCopyOfListenerList().contains(this.loggerContextListener)) {
            context.addListener((LoggerContextListener)this.loggerContextListener);
            this.logger.debug("Nexus logger context listener installed");
        }
    }

    private void readCustomisations() {
        LogConfigurationCustomizer.Configuration customizerConfiguration = new LogConfigurationCustomizer.Configuration(){

            @Override
            public void setLoggerLevel(String name, LoggerLevel level) {
                LogbackLogManager.this.customisations.put(Preconditions.checkNotNull((Object)name), Preconditions.checkNotNull((Object)((Object)level)));
            }
        };
        this.customisations.clear();
        for (LogConfigurationCustomizer customizer : this.logConfigurationCustomizers) {
            customizer.customize(customizerConfiguration);
        }
    }

    private void applyCustomisations() {
        for (Map.Entry<String, LoggerLevel> entry : this.customisations.entrySet()) {
            if (LoggerLevel.DEFAULT.equals((Object)entry.getValue())) continue;
            this.setLogbackLoggerLevel(entry.getKey(), this.convert(entry.getValue()));
        }
    }

    private class NexusLoggerContextListener
    implements LoggerContextListener {
        private NexusLoggerContextListener() {
        }

        public boolean isResetResistant() {
            return true;
        }

        public void onStart(LoggerContext context) {
        }

        public void onReset(LoggerContext context) {
            LogbackLogManager.this.applyCustomisations();
        }

        public void onStop(LoggerContext context) {
        }

        public void onLevelChange(ch.qos.logback.classic.Logger logger, Level level) {
        }
    }
}

